<?php defined('BASEPATH') OR exit('No direct script access allowed'); ?>
<?php
class Web extends MY_Controller {
    protected $limit, $offset;
    public function __construct(){

        //$this->output->cache(60);
        parent::__construct();

        $this->load->library(['form_validation','bcrypt','email','session','zip','user_agent']);
        $this->load->helper(['html','form','url','security','string','file','directory','mobile']);
        $this->load->model('CommonModel','common_model');
        $this->load->model('admin/AdminlteModel','adminlte_model');
         error_reporting(0);

         date_default_timezone_set('Asia/Kolkata');
         $this->load->library('bcrypt');
         $this->load->library('Facebook');
         $this->load->library('instagram_api');
         $this->load->library(array('twconnect'));
         $this->load->library('Googleplus');
		     $this->hits=$this->tracker_model->count_g_visit();
        // $this->output->delete_cache('Web');


    }
    public function delete_file_cache() {
      $this->output->delete_cache('Web');
   }


    public function get_country_state(){
        $postData   =   $this->input->post();
        $data       =   $this->common_model->get_country_state($postData);
        echo json_encode($data);
    }
    public function get_state_city(){
        $postData   =   $this->input->post();
        $data       =   $this->common_model->get_state_city($postData);
        echo json_encode($data);
    }
    // public function my_test(){
    //   $this->load->helper('mobile');
    //   echo is_MTC();
    // }
    public function index(){

        //  $this->benchmark->mark('code_start');
        //$this->output->cache(30);
        //$this->output->delete_cache();
        // Deletes cache for /foo/bar
        // $this->output->delete_cache('/foo/bar');
        //$this->output->enable_profiler(TRUE);
        $this->load->view('web/header',['title'=>'Home :: TOG',"hits"=>$this->hits]);
        $this->load->view('web/index');
        $this->load->view('web/footer-home');
        //$this->benchmark->mark('code_end');
        //echo $this->benchmark->elapsed_time('code_start', 'code_end');
        //echo "<br>";
        //echo $this->benchmark->memory_usage();
        //die;

    }
    public function getCityDepartment(){
        // POST data
        $postData = $this->input->post();// get data
        $data     = $this->common_model->getCityDepartment($postData);
        echo json_encode($data);
    }
    public function class_status(){
        $req_dump = print_r($_REQUEST, TRUE);
        $fp = fopen(base_url('uploads/request.txt'), 'a');
        fwrite($fp, $req_dump);
        if(count($_FILES)>0)
        {
        fwrite($fp,print_r($_FILES, true));
        fwrite($fp,file_get_contents($_FILES['file0']['tmp_name']));
        }
        fclose($fp);
    }
    function get_xml_from_url($url){
        $this->load->helper('xml');
        $ch = curl_init();

        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0 (Windows; U; Windows NT 5.1; en-US; rv:1.8.1.13) Gecko/20080311 Firefox/2.0.0.13');

        $xmlstr = curl_exec($ch);
        curl_close($ch);

        return $xmlstr;
    }
    public function test_status(){
        $this->load->helper('xml');
        $url      = 'https://theonlinegurukul.com/class-status';
        $item     = new SimpleXMLElement($url, null, true);
        $title    = $item->class_id;
        echo $title;
    }
    public function user_lobby(){
        if($this->session->userdata('ss_id')){return redirect('Student');}
        if($this->session->userdata('ts_id')){return redirect('Teacher');}
        if($this->session->userdata('ad_id')){return redirect('Admin');}
        if((!isset($_SESSION['ss_id']))&& (!isset($_SESSION['ss_id']))&& (!isset($_SESSION['ss_id']))){return redirect('Web');}
    }


    public function contact_us()
    {
        $this->load->view('web/header',['title'=>'CONTACT US :: TOG',"hits"=>$this->hits]);
        $this->form_validation->set_rules('first_name','First Name','required|xss_clean|trim');
        $this->form_validation->set_rules('last_name','Last Name','required|xss_clean|trim');
        $this->form_validation->set_rules('email','Email','required|trim|xss_clean|valid_email');
        $this->form_validation->set_rules('mobile','Mobile','required|xss_clean|trim|exact_length[10]');
        $this->form_validation->set_rules('country','Country','required|xss_clean|trim');
        $this->form_validation->set_rules('zip_code','Zip code','required|xss_clean|trim');
        $this->form_validation->set_rules('profile','Profile','required|xss_clean|trim');
        $this->form_validation->set_rules('subject','Subject','required|xss_clean|trim');
        $this->form_validation->set_rules('message','Message','required|xss_clean|trim|max_length[300]');
       $country_list =   $this->common_model->country_list();
        if($this->form_validation->run()){
            $first_name			=		strtolower($this->input->post('first_name'));
            $last_name		    =		strtolower($this->input->post('last_name'));
            $email		        =		strtolower($this->input->post('email'));
            $mobile		        =		strtolower($this->input->post('mobile'));
            $country			=		strtolower($this->input->post('country'));
            $zip_code			=		strtolower($this->input->post('zip_code'));
            $profile			=		strtolower($this->input->post('profile'));
            $date_of_birth	    =		strtolower($this->input->post('subject'));
            $message			=		strtolower($this->input->post('message'));
            $data   =array('first_name'=>$first_name,'last_name'=>$last_name,'email'=>$email,'mobile'=>$mobile,
                'country'=>$country,'zipcode'=>$zip_code,'profile'=>$profile,'date_of_birth'=>$date_of_birth,
                'message'=>$message,
            );
           $insert_id=   $this->common_model->add_contact_us($data);
           if($insert_id!=""){

               $config['mailtype']     = 'html';
               $this->email->initialize($config);
               $this->email->from('helpdesk@theonlinegurukul.com', 'theOnlineGurukul Pvt. Ltd.');
               $this->email->bcc(['helpdesk@theonlinegurukul.com']);
               $this->email->to($email);
               $this->email->subject('Thanks for Contact Us - TOG will get back to you soon');

               $link1          =  base_url("assets/web/images/bg-email.png");
               $link2          =  base_url("assets/web/images/bg-footer.png");

               $htmlContent	=	'<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
  <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>Thanks for contact us</title>
  <style type="text/css" media="screen">

    /* Force Hotmail to display emails at full width */
    .ExternalClass {
      display: block !important;
      width: 100%;
    }

    /* Force Hotmail to display normal line spacing */
    .ExternalClass,
    .ExternalClass p,
    .ExternalClass span,
    .ExternalClass font,
    .ExternalClass td,
    .ExternalClass div {
      line-height: 100%;
    }

    body,
    p,
    h1,
    h2,
    h3,
    h4,
    h5,
    h6 {
      margin: 0;
      padding: 0;
    }

    body,
    p,
    td {
      font-family: Arial, Helvetica, sans-serif;
      font-size: 15px;
      color: #333333;
      line-height: 1.5em;
    }

    h1 {
        text-align: center;
    font-size: 20px;
    font-weight: bold;
    line-height: 24px;
    }

    body,
    p {
      margin-bottom: 0;
      -webkit-text-size-adjust: none;
      -ms-text-size-adjust: none;
    }

    img {
      outline: none;
      text-decoration: none;
      -ms-interpolation-mode: bicubic;
    }

    a img {
      border: none;
    }

    .background {
                background-color: #eeeeee;
}


    table.background {
      margin: 0;
      padding: 0;
      width: 100% !important;
    }

    .block-img {
      display: block;
      line-height: 0;
    }

    a {
      color: white;
      text-decoration: none;
    }

    a,
    a:link {
      color: #2A5DB0;
      text-decoration: underline;
    }

    table td {
      border-collapse: collapse;
    }

    td {
      vertical-align: top;
      text-align: left;
    }

    .wrap {
	    margin-top: 0px;
      width: 600px;
    }

    .wrap-cell {
      padding-top: 30px;
      padding-bottom: 30px;
    }

    .header-cell,
    .body-cell,
    .footer-cell {
      padding-left: 20px;
      padding-right: 20px;
    }

    .header-cell {


      color: #ffffff;
    }

    .body-cell {
      background-color: #ffffff;
      padding-top:16px;
      padding-bottom: 34px;
    }

    .footer-cell {

      text-align: center;
      font-size: 13px;
      padding-top:13px;
      padding-bottom: 30px;
    }

    .card {
      width: 400px;
      margin: 0 auto;
    }

    .data-heading {
      text-align: right;
      padding: 10px;
      background-color: #ffffff;
      font-weight: bold;
    }

    .data-value {
      text-align: left;
      padding: 10px;
      background-color: #ffffff;
    }

    .force-full-width {
      width: 100% !important;
    }

  </style>
  <style type="text/css" media="only screen and (max-width: 600px)">
    @media only screen and (max-width: 600px) {
      body[class*="background"],
      table[class*="background"],
      td[class*="background"] {
        background: #eeeeee !important;
      }

      table[class="card"] {
        width: auto !important;
      }

      td[class="data-heading"],
      td[class="data-value"] {
        display: block !important;
      }

      td[class="data-heading"] {
        text-align: left !important;
        padding: 10px 10px 0;
      }

      table[class="wrap"] {
        width: 100% !important;
      }

      td[class="wrap-cell"] {
        padding-top: 0 !important;
        padding-bottom: 0 !important;
      }
    }


  </style>
</head>

<body leftmargin="0" marginwidth="0" topmargin="0" marginheight="0" offset="0" bgcolor="" class="background">
  <table align="center" border="0" cellpadding="0" cellspacing="0" height="100%" width="100%" class="background">
    <tr>
      <td align="center" valign="top" width="100%" class="background">
        <center>
          <table cellpadding="0" cellspacing="0" width="600" class="wrap">
            <tr>
              <td valign="top" class="wrap-cell" style="padding-top:30px; padding-bottom:30px;">
                <table cellpadding="0" cellspacing="0" class="force-full-width">
				 <tr>
                    <td height="8" bgcolor="#ededed" class="contents" style="width:100%; border-top-left-radius:0px; border-top-right-radius:0px"></td>
                  </tr>
                  <tr>
                   <td height="65" valign="top" class="header-cell" style="padding-top:7 px; padding-bottom:7px; background-image:url('.$link1.')">
                   <a href="'.site_url().'" target="_blank">
                   <img src="'.base_url("assets/web/images/20.png").'" width="150"  alt="" style="border-width:0; max-width:100px; display:block" /></a>
                   </td>
                   </tr>
                   <tr>
                   <td height="4" bgcolor="#ffa50070" class="contents" style="width:100%; border-top-left-radius:0px; border-top-right-radius:0px"><!--  border-top-left-radius:10px; --> <!-- border-top-right-radius:10px" --></td>
                                          </tr>

                  <tr>
                    <td valign="top" class="body-cell">

                      <table cellpadding="0" cellspacing="0" width="100%" bgcolor="#ffffff">
                      <tr>
                      <td valign="top" style="padding-bottom:15px; background-color:#ffffff;">
                      <h1>Here is your provided info </h1>
                      </td>
                      </tr>
                     <tr>
                <td valign="top" style="padding-bottom:15px; background-color:#ffffff; text-align:center;">
                <p>First Name<span><b>'.nbs(5).':'.nbs(5).ucwords($first_name).'</b></span></p>
                <p>Last Name<span><b>'.nbs(5).':'.nbs(5).ucwords($last_name).'</b></span></p>
                <p>Email<span><b>'.nbs(5).':'.nbs(5).strtolower($email).'</b></span></p>
                <p>Moblie<span><b>'.nbs(5).':'.nbs(5).ucwords($mobile).'</b></span></p>
                <p>Zipcode<span><b>'.nbs(5).':'.nbs(5).ucwords($zip_code).'</b></span> </p>
                <p>Profile<span><b>'.nbs(5).':'.nbs(5).ucwords($profile).'</b></span> </p>
                <p>DOB<span><b>'.nbs(5).':'.nbs(5).ucwords($date_of_birth).'</b></span></p>
                </td>
                </tr>
                </tr>
                <tr>
                <td valign="top" style="padding-bottom:20px; background-color:#ffffff;">
               <p style="color:#5b5f65; font-size:14px; text-align:center; font-family: Verdana, Geneva, sans-serif">
                '.ucwords($message).'<br>
                </p>
                      </td></tr>
                      <tr>
                      <td valign="top" style="padding-bottom:20px; background-color:#ffffff;">
                        <center><p style="color:#5b5f65; font-size:14px; text-align:center; font-family: Verdana, Geneva, sans-serif">
                      Thanks for contact us, we will get back to you soon.<br>
                      </p></center><br>
                      <center>    <a href="http://theonlinegurukul.com"
                      style="background-color:#ffa500;color:#ffffff;display:inline-block;font-family:sans-serif;font-size: 16px;line-height:37px;text-align:center;text-decoration:none;width:165px;-webkit-text-size-adjust:none;">Get in Touch with us</a>
                      </center>
                      <br>
                        <center><p style="color:#5b5f65; font-size:14px; text-align:center;font-family: Verdana, Geneva, sans-serif">

                      Thank you for your patience. Please contact us for any inconvenience caused to you.<br>


                      </p>  </center>
                      </td>
                      </tr>
                      <tr>
                      <td>
                      <table cellspacing="0" cellpadding="0" width="100%" bgcolor="#ffffff">
                      <tr>
                      <td style="width:200px;background:#008000;">
                      <div><!--[if mso]>
                      <v:rect xmlns:v="urn:schemas-microsoft-com:vml" xmlns:w="urn:schemas-microsoft-com:office:word" href="#" style="height:40px;v-text-anchor:middle;width:200px;" stroke="f" fillcolor="#008000">
                      <w:anchorlock/>
                      <center>
                      <![endif]-->


                      <!--[if mso]>
                      </center>
                      </v:rect>
                      <![endif]--></div>
                      </td>
                      <td width="360" style="background-color:#ffffff; font-size:0; line-height:0;">&nbsp;</td>
                      </tr>
                      </table>
                      </td>
                      </tr>
                      <tr>
                      <td style="padding-top:20px;background-color:#ffffff;">
                      <p style="color:black;  font-family: Comic Sans MS, Textile, cursive; font-weight: bold;">

                      Regards.<br>
                      The Online Gurukul
                      </p>
                      </td>
                      </tr>
                      </table>
                      </td>
                      </tr>
                      <tr>
                      <td height="4" bgcolor="#ffa50070" class="contents" style="width:100%; border-top-left-radius:0px; border-top-right-radius:0px"></td>
                      </tr>

                      <tr>
                       <td height="65" align="center" class="header-cell" style="padding-top:7px; padding-bottom:7px; background-image:url('.$link1.')">

                      <center><span class="email-cos" style="font-size: 14px; color: #ffa500; font-weight: bolder;">Email :</span>
                      <a class="txs" href="mailto:helpdesk@theonlinegurukul.com" style="color:#000;  font-size:17px;text-decoration:none;" target="_blank">helpdesk@theonlinegurukul.com </a>
                      <br>
                      <span class="email-cos" style="font-size: 14px; color: #ffa500; font-weight: bolder;">Phone :-</span>
                      <a class="txs" href="tel:+91-0124-4272441" style="color:#000;  font-size:17px;text-decoration:none;" target="_blank"> 91-0124-4272441</a>
                      </center>
                      </td>
                      <tr>

                      </tr>



                      </table>
                      </td>
                      </tr>
                      </table>
                      </center>
                      </td>
                      </tr>
                      </table>

                      </body>
                      </html>';
               $this->email->message($htmlContent);

               if ($this->email->send()) {
                   $this->session->set_flashdata('success', " Thanks for contact us, we will get back to you soon.");
                   return redirect('contact-us');
               }
               else{
                   //show_error($this->email->print_debugger());
                   $this->session->set_flashdata('danger', " Error in sending Email, we will get back to you soon");
                   return redirect('contact-us');
               }

           }

        }else{
            $this->load->view('web/contact-us',['country_list'=>$country_list]);
        }
        $this->load->view('web/footer');
    }
    public function courses()
    {
        $this->load->view('web/header',['title'=>'COURSES :: TOG',"hits"=>$this->hits]);
        $this->load->view('web/courses');
        $this->load->view('web/footer');
    }
    public function faq()
    {
        $this->load->view('web/header',['title'=>'FAQ :: TOG',"hits"=>$this->hits]);
        $this->load->view('web/faq',[]);
        $this->load->view('web/footer');
    }

    public function how_it_works(){
        $this->load->view('web/header',['title'=>'HOW IT WORKS :: TOG',"hits"=>$this->hits]);
        $this->load->view('web/how-it-works');
        $this->load->view('web/footer');
    }
    public function register(){
        $this->load->view('web/header',['title'=>'REGISTER :: TOG',"hits"=>$this->hits]);
        $this->load->view('web/register-type');
        $this->load->view('web/footer');
    }
    public function tution_signup(){
        $this->load->view('web/header',['title'=>'TUTION SIGNUP :: TOG',"hits"=>$this->hits]);
        $this->load->view('web/register');
        $this->load->view('web/footer');
    }
    public function tution_signin(){
        $this->load->view('web/header',['title'=>'TUTION SIGNIN :: TOG',"hits"=>$this->hits]);
        $this->load->view('web/login');
        $this->load->view('web/footer');
    }
    public function login(){
        $this->load->view('web/header',['title'=>'LOGIN :: TOG',"hits"=>$this->hits]);
        $this->load->view('web/login-type');
        $this->load->view('web/footer');
    }
    public function student_login(){
        $this->load->view('web/header',['title'=>'STUDENT SIGNIN :: TOG',"hits"=>$this->hits]);
        $email_1=$this->input->post('email');
        if($this->session->userdata('ss_id')){return redirect('Student');}
        if($this->session->userdata('ts_id')){return redirect('Teacher');}
        if($this->session->userdata('ad_id')){return redirect('Admin');}

        if($this->session->userdata('st_logged_in')==true){
            $sessiondata =  $this->session->all_userdata();
            $userid      =  $sessiondata['ss_id'];
            redirect('Student');
        }
        else{
          $this->form_validation->set_rules('email','Email','required|trim|xss_clean|valid_email');
          $this->form_validation->set_rules('password','Password','required|xss_clean|trim');
          $category			=		$this->common_model->category_list();
          if($this->form_validation->run()){
              $email			=		$this->input->post('email');
              $password		=		$this->input->post('password');
              $login			=		$this->common_model->login_valid($email,'2');
              //$hash 	    = 	    $this->bcrypt->hash_password($password);
              $counta  =    $this->common_model->login_valid_count($email,'2');
             if($counta>0){
                  if($login->is_confirmed==1){
                      if($this->bcrypt->check_password($password, $login->password)){
                          $this->load->library('session');
                          $udata=array('ss_id'=>$login->hashtag.$login->id,
                            'st_logged_in'=>true,
                        );
                        //if(is_MTC()=='phone'){
                          $this->session->set_userdata($udata);
                          $sessionid=session_id();
                          $this->common_model->setStsession($login->hashtag.$login->id,$sessionid);
                        //}

                          //echo $this->session->userdata('ss_id');die;
                          return redirect('Student');
                      }
                      else{
                          $this->session->set_flashdata('danger','Invalid Username/Password');
                          return redirect('student/signin');
                      }
                  }else{
                      $this->session->set_flashdata('danger','Email is not verified,please verify by clicking on link at your email Address');
                      return redirect('student/signin');
                  }
              }
              else{
                  $this->session->set_flashdata('danger','Email is not registerd yet');
                  return redirect('student/signin');
              }
          }
          else{
              $gplus_login_url    =   $this->googleplus->loginURL();
              $this->load->view('web/login-student',['category'=>$category,'gplus_login'=>$gplus_login_url,]);
          }

        }
        $this->load->view('web/footer');
    }

    // public function teacher_login(){
    //     $this->load->view('web/header',['title'=>'TEACHER SIGNIN :: TOG',"hits"=>$this->hits]);
    //     if($this->session->userdata('ss_id')){return redirect('Student');}
    //     if($this->session->userdata('ts_id')){return redirect('Teacher');}
    //     if($this->session->userdata('ad_id')){return redirect('Admin');}
    //
    //     if($this->session->userdata('ts_logged_in')==true){
    //        $sessiondata =  $this->session->all_userdata();
    //         $userid      =  $sessiondata['ts_id'];
    //         redirect('Teacher');
    //     }
    //     else{
    //     $this->form_validation->set_rules('email','Email','required|trim|xss_clean|valid_email');
    //     $this->form_validation->set_rules('password','Password','required|xss_clean|trim');
    //     $category			=		$this->common_model->category_list();
    //     if($this->form_validation->run()){
    //         $email			=		$this->input->post('email');
    //         $password		=		$this->input->post('password');
    //         $login			=		$this->common_model->login_valid($email,'1');
    //         $counta     =   $this->common_model->login_valid_count($email,'1');
    //         if($counta>0){
    //             if($this->bcrypt->check_password($password, $login->password)){
    //                 if($login->is_confirmed==1){
    //                     if($login->admin_approve==1){
    //                             $this->load->library('session');
    //                             $udata=array('ts_id'=>$login->hashtag.$login->id,
    //                                'ts_logged_in'=>true,
    //                            );
    //                              $this->session->set_userdata($udata);
    //                              $sessionid=session_id();
    //                              $this->common_model->setStsession($login->hashtag.$login->id,$sessionid);
    //                      //echo $this->session->userdata('ss_id');die;
    //                      return redirect('Teacher');
    //                     }
    //                     else{
    //                         $this->session->set_flashdata('danger','Profile verification is under process,Support team will contact you soon');
    //                         return redirect('teacher/signin');
    //                     }
    //                 }else{
    //                     $this->session->set_flashdata('danger','Email is not verified,please verify by clicking on link at your email Address');
    //                     return redirect('teacher/signin');
    //                 }
    //             }
    //             else{
    //                 $this->session->set_flashdata('danger','Invalid Username/Password');
    //                 return redirect('teacher/signin');
    //             }
    //         }
    //         else{
    //             $this->session->set_flashdata('danger','Email is not registerd yet');
    //             return redirect('teacher/signin');
    //         }
    //     }
    //     else{
    //         $this->load->view('web/teacher-login',['category'=>$category]);
    //     }
    //   }
    //     $this->load->view('web/footer');
    //  }

    public function student_forget_pass(){

        $this->load->view('web/header',['title'=>'STUDENT FORGET PASSWORD :: TOG',"hits"=>$this->hits]);
        $this->form_validation->set_error_delimiters('<p class="font-bold col-pink">', '</p>');
        $this->form_validation->set_rules('email','Email Address','required|trim|xss_clean|valid_email');

        if($this->form_validation->run()){
            $email			=		$this->input->post('email');
            $count			=		$this->common_model->login_valid_count($email,'2');

            if($count>0){
                $row        =       $this->common_model->login_valid($email,'2');
                $config['mailtype']     = 'html';
                $this->email->initialize($config);
                $this->email->from('helpdesk@theonlinegurukul.com', 'theOnlineGurukul Pvt. Ltd.');
                //$this->email->to(['narender.rathore@deconglobalsolutions.com','narender.rathore@theonlinegurukul.com']);
                $this->email->to($email);
                $this->email->subject('Account password reset - TOG  Admin');
                $salthash		=   random_string('alnum', 9);


                $link1          =  base_url("assets/web/images/bg-email.png");
                $link2          =  base_url("assets/web/images/bg-footer.png");

                $htmlContent	=	'<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
  <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>USER ACCOUNT PASSWORD RESET</title>
  <style type="text/css" media="screen">

    /* Force Hotmail to display emails at full width */
    .ExternalClass {
      display: block !important;
      width: 100%;
    }

    /* Force Hotmail to display normal line spacing */
    .ExternalClass,
    .ExternalClass p,
    .ExternalClass span,
    .ExternalClass font,
    .ExternalClass td,
    .ExternalClass div {
      line-height: 100%;
    }

    body,
    p,
    h1,
    h2,
    h3,
    h4,
    h5,
    h6 {
      margin: 0;
      padding: 0;
    }

    body,
    p,
    td {
      font-family: Arial, Helvetica, sans-serif;
      font-size: 15px;
      color: #333333;
      line-height: 1.5em;
    }

    h1 {
        text-align: center;
    font-size: 20px;
    font-weight: bold;
    line-height: 24px;
    }

    body,
    p {
      margin-bottom: 0;
      -webkit-text-size-adjust: none;
      -ms-text-size-adjust: none;
    }

    img {
      outline: none;
      text-decoration: none;
      -ms-interpolation-mode: bicubic;
    }

    a img {
      border: none;
    }

    .background {
                background-color: #eeeeee;
}


    table.background {
      margin: 0;
      padding: 0;
      width: 100% !important;
    }

    .block-img {
      display: block;
      line-height: 0;
    }

    a {
      color: white;
      text-decoration: none;
    }

    a,
    a:link {
      color: #2A5DB0;
      text-decoration: underline;
    }

    table td {
      border-collapse: collapse;
    }

    td {
      vertical-align: top;
      text-align: left;
    }

    .wrap {
	    margin-top: 0px;
      width: 600px;
    }

    .wrap-cell {
      padding-top: 30px;
      padding-bottom: 30px;
    }

    .header-cell,
    .body-cell,
    .footer-cell {
      padding-left: 20px;
      padding-right: 20px;
    }

    .header-cell {


      color: #ffffff;
    }

    .body-cell {
      background-color: #ffffff;
      padding-top:16px;
      padding-bottom: 34px;
    }

    .footer-cell {

      text-align: center;
      font-size: 13px;
      padding-top:13px;
      padding-bottom: 30px;
    }

    .card {
      width: 400px;
      margin: 0 auto;
    }

    .data-heading {
      text-align: right;
      padding: 10px;
      background-color: #ffffff;
      font-weight: bold;
    }

    .data-value {
      text-align: left;
      padding: 10px;
      background-color: #ffffff;
    }

    .force-full-width {
      width: 100% !important;
    }

  </style>
  <style type="text/css" media="only screen and (max-width: 600px)">
    @media only screen and (max-width: 600px) {
      body[class*="background"],
      table[class*="background"],
      td[class*="background"] {
        background: #eeeeee !important;
      }

      table[class="card"] {
        width: auto !important;
      }

      td[class="data-heading"],
      td[class="data-value"] {
        display: block !important;
      }

      td[class="data-heading"] {
        text-align: left !important;
        padding: 10px 10px 0;
      }

      table[class="wrap"] {
        width: 100% !important;
      }

      td[class="wrap-cell"] {
        padding-top: 0 !important;
        padding-bottom: 0 !important;
      }
    }


  </style>
</head>

<body leftmargin="0" marginwidth="0" topmargin="0" marginheight="0" offset="0" bgcolor="" class="background">
  <table align="center" border="0" cellpadding="0" cellspacing="0" height="100%" width="100%" class="background">
    <tr>
      <td align="center" valign="top" width="100%" class="background">
        <center>
          <table cellpadding="0" cellspacing="0" width="600" class="wrap">
            <tr>
              <td valign="top" class="wrap-cell" style="padding-top:30px; padding-bottom:30px;">
                <table cellpadding="0" cellspacing="0" class="force-full-width">
				 <tr>
                    <td height="8" bgcolor="#ededed" class="contents" style="width:100%; border-top-left-radius:0px; border-top-right-radius:0px"></td>
                  </tr>
                  <tr>
                   <td height="65" valign="top" class="header-cell" style="padding-top:5px; padding-bottom:3px; background-image:url('.$link1.')">
                   <a href="'.site_url().'" target="_blank">
                   <img src="'.base_url("assets/web/images/20.png").'" width="150"  alt="" style="border-width:0; max-width:100px; display:block" /></a>
                   </td>
                   </tr>
                   <tr>
                   <td height="4" bgcolor="#ffa50070" class="contents" style="width:100%; border-top-left-radius:0px; border-top-right-radius:0px"><!--  border-top-left-radius:10px; --> <!-- border-top-right-radius:10px" --></td>
                                          </tr>

                  <tr>
                    <td valign="top" class="body-cell">

                      <table cellpadding="0" cellspacing="0" width="100%" bgcolor="#ffffff">
                      <tr>
                      <td valign="top" style="padding-bottom:15px; background-color:#ffffff;">
                      <h1>Password reset link</h1>
                      </td>
                      </tr>
                      <tr>
                      <td valign="top" style="padding-bottom:20px; background-color:#ffffff;">
                      <p style="color:#5b5f65; font-size:14px; text-align:justify; font-family: Verdana, Geneva, sans-serif">
                      Your password reset link is as follows. Please click the link
                      below to reset your password.<br>
                      </p>
                      <center>    <a href="'.site_url("student/password/reset/").$row->hashtag.$row->id.$salthash.'"
                      style="background-color:#ffa500;color:#ffffff;display:inline-block;font-family:sans-serif;font-size: 16px;line-height:37px;text-align:center;text-decoration:none;width:165px;-webkit-text-size-adjust:none;">Password Reset Link</a>
                      </center>
                      <br>
                      <p style="color:#5b5f65; font-size:14px; text-align:justify;font-family: Verdana, Geneva, sans-serif">

                      Thank you for your patience. Please contact us for any inconvenience caused to you.<br>


                      </p>
                      </td>
                      </tr>
                      <tr>
                      <td>
                      <table cellspacing="0" cellpadding="0" width="100%" bgcolor="#ffffff">
                      <tr>
                      <td style="width:200px;background:#008000;">
                      <div><!--[if mso]>
                      <v:rect xmlns:v="urn:schemas-microsoft-com:vml" xmlns:w="urn:schemas-microsoft-com:office:word" href="#" style="height:40px;v-text-anchor:middle;width:200px;" stroke="f" fillcolor="#008000">
                      <w:anchorlock/>
                      <center>
                      <![endif]-->


                      <!--[if mso]>
                      </center>
                      </v:rect>
                      <![endif]--></div>
                      </td>
                      <td width="360" style="background-color:#ffffff; font-size:0; line-height:0;">&nbsp;</td>
                      </tr>
                      </table>
                      </td>
                      </tr>
                      <tr>
                      <td style="padding-top:20px;background-color:#ffffff;">
                      <p style="color:black;  font-family: Comic Sans MS, Textile, cursive; font-weight: bold;">

                      Regards.<br>
                      The Online Gurukul
                      </p>
                      </td>
                      </tr>
                      </table>
                      </td>
                      </tr>
                      <tr>
                      <td height="4" bgcolor="#ffa50070" class="contents" style="width:100%; border-top-left-radius:0px; border-top-right-radius:0px"></td>
                      </tr>

                      <tr>
                       <td height="65" align="center" class="header-cell" style="padding-top:7px; padding-bottom:7px; background-image:url('.$link1.')">

                      <center><span class="email-cos" style="font-size: 14px; color: #ffa500; font-weight: bolder;">Email :</span>
                      <a class="txs" href="mailto:helpdesk@theonlinegurukul.com" style="color:#000;  font-size:17px;text-decoration:none;" target="_blank">helpdesk@theonlinegurukul.com </a>
                      <br>
                      <span class="email-cos" style="font-size: 14px; color: #ffa500; font-weight: bolder;">Phone :-</span>
                      <a class="txs" href="tel:+91-0124-4272441" style="color:#000;  font-size:17px;text-decoration:none;" target="_blank"> 91-0124-4272441</a>
                      </center>
                      </td>
                      <tr>
                      </tr>
                      </table>
                      </td>
                      </tr>
                      </table>
                      </center>
                      </td>
                      </tr>
                      </table>

                      </body>
                      </html>';
                $this->email->message($htmlContent);
                if ($this->email->send()) {
                    $this->session->set_flashdata('success', " Password resent link mail sent to your account,Click link to reset password");
                    return redirect('student/password/forget');
                }
                else{
                    //show_error($this->email->print_debugger());
                    $this->session->set_flashdata('danger', " Error in sending Email, please contact Admin");
                    return redirect('student/password/forget');
                }
                //return redirect('Web/student_forget_password');
            }
            else{
                $this->session->set_flashdata('danger','This Email is not registered with us as Student Profile');
                return redirect('user/info');
            }
        }
        else{
            $this->load->view('web/student_forget_password',['category'=>$category]);
        }

        $this->load->view('web/footer');
    }
    public function user_messages(){
        $this->load->view('web/header',['title'=>'USER MESSAGES :: TOG',"hits"=>$this->hits]);
        $this->load->view('web/user_messages');
        $this->load->view('web/footer');
    }

    public function student_pass_reset($hash){
        $this->load->library('email');

        $this->load->view('web/header',['title'=>'STUDENT PASSWORD RESET :: TOG',"hits"=>$this->hits]);
        $this->form_validation->set_error_delimiters('<p class="font-bold col-pink">', '</p>');
        $this->form_validation->set_rules('password','password','required|trim|xss_clean|min_length[8]|max_length[15]');
        $this->form_validation->set_rules('confirm_password','confirm_password','required|trim|xss_clean|min_length[8]|max_length[15]|matches[password]');
        $hashnew    =   substr($hash,-9);
        $hashcode   =   substr($hash,0,16);
        $hashidtag  =   strstr($hash,$hashnew,true);
        $hashid     =   substr($hashidtag,16);
        if($this->form_validation->run()){
            $password			      =   trim($this->input->post('password'));
            $hash_password 	    = 	$this->bcrypt->hash_password($password);
            $count              =   $this->common_model->count_email_confirm($hashid,$hashcode);
            if($count>0){
                $getrow = $this->common_model->select_email_confirm($hashid,$hashcode);
                if($getrow->category==1){
                    $this->common_model->email_verified_process_done($hashid,$hashcode);
                    $this->common_model->reset_password_user($hashid,$hashcode,$hash_password);
                    $hashnew    =    random_string('alnum', 16);
                    $this->common_model->update_hash($hashid,$hashnew);
                    $this->session->set_flashdata('success', " Email Password reset Sucessfully,please Login to your Account");
                    return redirect('teacher/signin');

                }elseif($getrow->category==2){
                    echo $hashid; echo $hashcode;
                    $this->common_model->email_verified_process_done($hashid,$hashcode);
                    $this->common_model->reset_password_user($hashid,$hashcode,$hash_password);
                    $hashnew    =    random_string('alnum', 16);
                    $this->common_model->update_hash($hashid,$hashnew);
                    $this->session->set_flashdata('success', " Email Password reset Sucessfully,please Login to your Account");
                    return redirect('student/signin');
                }
                else{
                    $this->common_model->email_verified_process_done($hashid,$hashcode);
                    $this->common_model->reset_password_user($hashid,$hashcode,$hash_password);
                    $hashnew    =    random_string('alnum', 16);
                    $this->common_model->update_hash($hashid,$hashnew);
                    $this->session->set_flashdata('success', " Email Password reset Sucessfully,please Login to your Account");
                    return redirect('user/info');
                }
            }else{

                $this->session->set_flashdata('danger', " Link is already expired,please contact Admin for assistance  ");
                return redirect('user/info');
            }
        }else{
            $this->load->view('web/student_password_reset');
        }

        $this->load->view('web/footer');
    }

    public function email_verification_account($hash){
        $hashnew    =   substr($hash,-9);
        $hashcode   =   substr($hash,0,16);
        $hashidtag  =   strstr($hash,$hashnew,true);
        $hashid     =   substr($hashidtag,16);
        $count      =   $this->common_model->count_email_confirm($hashid,$hashcode);
        if($count>0){
            $getrow = $this->common_model->select_email_confirm($hashid,$hashcode);
            if($getrow->category==1){
                $this->common_model->email_verified_process_done($hashid,$hashcode);
                $hashnew    =    random_string('alnum', 16);

                $this->common_model->update_hash($hashid,$hashnew);
                $this->session->set_flashdata('success', " Email verified,please Login to your Account");
                return redirect('teacher/signin');

            }elseif($getrow->category==2){
                $this->common_model->email_verified_process_done($hashid,$hashcode);
                $hashnew    =    random_string('alnum', 16);
                //echo $hashnew;die;
                $this->common_model->update_hash($hashid,$hashnew);
                $this->session->set_flashdata('success', " Email verified,please Login to your Account");
                return redirect('student/signin');
            }
            else{
                $this->common_model->email_verified_process_done($hashid,$hashcode);
                $hashnew    =    random_string('alnum', 16);
                $this->common_model->update_hash($hashid,$hashnew);
                $this->session->set_flashdata('success', " Email verified,please Login to your Account");
                return redirect('user/info');
            }
        }else{

            $this->session->set_flashdata('danger', " Link is already expired,please contact Admin for assistance  ");
            return redirect('user/info');
        }

    }

    public function student_signup(){
        $this->load->library('email');
        $this->load->view('web/header',['title'=>'STUDENT SIGNUP :: TOG',"hits"=>$this->hits]);
        $this->form_validation->set_rules('first_name','First Name','required|trim|xss_clean|max_length[15]');
        $this->form_validation->set_rules('last_name','Last Name','required|trim|xss_clean|max_length[15]');
        $this->form_validation->set_rules('mobile','Mobile no','required|trim|xss_clean|max_length[20]');
        $this->form_validation->set_rules('email','Email','required|trim|valid_email|xss_clean|callback_check_user');
        $this->form_validation->set_rules('password','Password','required|trim|xss_clean|max_length[15]|min_length[8]');
        $this->form_validation->set_rules('confirm_password','Confirm Password','required|trim|xss_clean|max_length[15]|min_length[8]|matches[password]');
        $this->form_validation->set_rules('gender','Gender','required|trim|xss_clean');
        $this->form_validation->set_rules('country','Country','required|trim|xss_clean');
        $category			     =		$this->common_model->category_list();
        $country			     =		$this->common_model->getcountry_dropdown();
        if($this->form_validation->run()){
            $email			   =		$this->input->post('email');
            $password		   =		$this->input->post('password');
            $first_name		 =		$this->input->post('first_name');
            $last_name		 =		$this->input->post('last_name');
            $mobile			   =		$this->input->post('mobile');
            $gender			   =		$this->input->post('gender');
            $country	     =		$this->input->post('country');
            $hash 			   = 		$this->bcrypt->hash_password($password);
            $hashtag		   =		random_string('alnum', 16);

            $data			     =		array('first_name'=> strtolower($first_name),'last_name'=> strtolower($last_name),
                'mobile'=>strtolower($mobile),'email'=>strtolower($email),'password'=>$hash,
                'category'=>'2','hashtag'=>$hashtag,'gender'=>$gender);
            $insert_id	   =		$this->common_model->insert_masteruser($data);
            $counter23     =    $this->common_model->find_duplicate_student_info($insert_id);
            if($counter23==0){
                $this->common_model->insert_extra_info(array(
                  'user_id'=>$insert_id,
                  "country"=>strtolower($this->input->post('country'))
                ));
            }else{
                $this->common_model->update_extra_info($insert_id,array(
                  "country"=>strtolower($this->input->post('country'))
                ));
            }
            if($insert_id!=""){

                $config['mailtype']     = 'html';
                $this->email->initialize($config);
                $this->email->from('helpdesk@theonlinegurukul.com', 'theOnlineGurukul Pvt. Ltd.');
                //$this->email->to(['narender.rathore@deconglobalsolutions.com','narender.rathore@theonlinegurukul.com']);
                $this->email->to($email);
                $this->email->subject('Email Account Verification - TOG  Admin');
                $salthash		    =	 random_string('alnum', 9);
                $link1          =  base_url("assets/web/images/bg-email.png");
                $link2          =  base_url("assets/web/images/bg-footer.png");

                $htmlContent = '
                   <!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
  <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>TOG ACCOUNT ACTIVATION LINK</title>
  <style type="text/css" media="screen">

    /* Force Hotmail to display emails at full width */
    .ExternalClass {
      display: block !important;
      width: 100%;
    }

    /* Force Hotmail to display normal line spacing */
    .ExternalClass,
    .ExternalClass p,
    .ExternalClass span,
    .ExternalClass font,
    .ExternalClass td,
    .ExternalClass div {
      line-height: 100%;
    }

    body,
    p,
    h1,
    h2,
    h3,
    h4,
    h5,
    h6 {
      margin: 0;
      padding: 0;
    }

    body,
    p,
    td {
      font-family: Arial, Helvetica, sans-serif;
      font-size: 15px;
      color: #333333;
      line-height: 1.5em;
    }

    h1 {
        text-align: center;
    font-size: 20px;
    font-weight: bold;
    line-height: 24px;
    }

    body,
    p {
      margin-bottom: 0;
      -webkit-text-size-adjust: none;
      -ms-text-size-adjust: none;
    }

    img {
      outline: none;
      text-decoration: none;
      -ms-interpolation-mode: bicubic;
    }

    a img {
      border: none;
    }

    .background {
                background-color: #eeeeee;
}


    table.background {
      margin: 0;
      padding: 0;
      width: 100% !important;
    }

    .block-img {
      display: block;
      line-height: 0;
    }

    a {
      color: white;
      text-decoration: none;
    }

    a,
    a:link {
      color: #2A5DB0;
      text-decoration: underline;
    }

    table td {
      border-collapse: collapse;
    }

    td {
      vertical-align: top;
      text-align: left;
    }

    .wrap {
	    margin-top: 0px;
      width: 600px;
    }

    .wrap-cell {
      padding-top: 30px;
      padding-bottom: 30px;
    }

    .header-cell,
    .body-cell,
    .footer-cell {
      padding-left: 20px;
      padding-right: 20px;
    }

    .header-cell {


      color: #ffffff;
    }

    .body-cell {
      background-color: #ffffff;
      padding-top:16px;
      padding-bottom: 34px;
    }

    .footer-cell {

      text-align: center;
      font-size: 13px;
      padding-top:13px;
      padding-bottom: 30px;
    }

    .card {
      width: 400px;
      margin: 0 auto;
    }

    .data-heading {
      text-align: right;
      padding: 10px;
      background-color: #ffffff;
      font-weight: bold;
    }

    .data-value {
      text-align: left;
      padding: 10px;
      background-color: #ffffff;
    }

    .force-full-width {
      width: 100% !important;
    }

  </style>
  <style type="text/css" media="only screen and (max-width: 600px)">
    @media only screen and (max-width: 600px) {
      body[class*="background"],
      table[class*="background"],
      td[class*="background"] {
        background: #eeeeee !important;
      }

      table[class="card"] {
        width: auto !important;
      }

      td[class="data-heading"],
      td[class="data-value"] {
        display: block !important;
      }

      td[class="data-heading"] {
        text-align: left !important;
        padding: 10px 10px 0;
      }

      table[class="wrap"] {
        width: 100% !important;
      }

      td[class="wrap-cell"] {
        padding-top: 0 !important;
        padding-bottom: 0 !important;
      }
    }
  </style>
</head>

<body leftmargin="0" marginwidth="0" topmargin="0" marginheight="0" offset="0" bgcolor="" class="background">
  <table align="center" border="0" cellpadding="0" cellspacing="0" height="100%" width="100%" class="background">
    <tr>
      <td align="center" valign="top" width="100%" class="background">
        <center>
          <table cellpadding="0" cellspacing="0" width="600" class="wrap">
            <tr>
              <td valign="top" class="wrap-cell" style="padding-top:30px; padding-bottom:30px;">
                <table cellpadding="0" cellspacing="0" class="force-full-width">
				            <tr>
                    <td height="8" bgcolor="#ededed" class="contents" style="width:100%; border-top-left-radius:0px; border-top-right-radius:0px"></td>
                  </tr>
                  <tr>
                   <td height="65" valign="top" class="header-cell" style="padding-top:7px; padding-bottom:7px; background-image:url('.$link1.')">
                   <a href="http://theonlinegurukul.com" target="_blank">
                   <img src="'.base_url("assets/web/images/20.png").'" width="150"  alt="" style="border-width:0; max-width:100px; display:block" /></a>
                   </td>
                   </tr>
                   <tr>
                   <td height="4" bgcolor="#ffa50070" class="contents" style="width:100%; border-top-left-radius:0px; border-top-right-radius:0px"><!--  border-top-left-radius:10px; --> <!-- border-top-right-radius:10px" --></td>
                  </tr>

                  <tr>
                    <td valign="top" class="body-cell">

                      <table cellpadding="0" cellspacing="0" width="100%" bgcolor="#ffffff">
                      <tr>
                      <td valign="top" style="padding-bottom:15px; background-color:#ffffff;">
                      <h1>User Email Address verification link</h1>
                      </td>
                      </tr>
                      <tr>
                      <td valign="top" style="padding-bottom:20px; background-color:#ffffff;">
                      <p style="color:#5b5f65; font-size:14px; text-align:justify; font-family: Verdana, Geneva, sans-serif">
                      Your TOG Account activation link is as follows. Please click the link
							               below to Activation of your Account.<br>
                      </p>
                      <center>    <a href="'.site_url("user/email/verify/").$hashtag.$insert_id.$salthash.'"
                      style="background-color:#ffa500;color:#ffffff;display:inline-block;font-family:sans-serif;font-size: 16px;line-height:37px;text-align:center;text-decoration:none;width:165px;-webkit-text-size-adjust:none;">Verify your Account</a>
                      </center>
                      <br>
                      <p style="color:#5b5f65; font-size:14px; text-align:justify;font-family: Verdana, Geneva, sans-serif">
                      Thank you for your patience. Please contact us for any inconvenience caused to you.<br>
                      </p>
                      </td>
                      </tr>
                      <tr>
                      <td>
                      <table cellspacing="0" cellpadding="0" width="100%" bgcolor="#ffffff">
                      <tr>
                      <td style="width:200px;background:#008000;">
                      <div><!--[if mso]>
                      <v:rect xmlns:v="urn:schemas-microsoft-com:vml" xmlns:w="urn:schemas-microsoft-com:office:word" href="#" style="height:40px;v-text-anchor:middle;width:200px;" stroke="f" fillcolor="#008000">
                      <w:anchorlock/>
                      <center>
                      <![endif]-->
                      <!--[if mso]>
                      </center>
                      </v:rect>
                      <![endif]--></div>
                      </td>
                      <td width="360" style="background-color:#ffffff; font-size:0; line-height:0;">&nbsp;</td>
                      </tr>
                      </table>
                      </td>
                      </tr>
                      <tr>
                      <td style="padding-top:20px;background-color:#ffffff;">
                      <p style="color:black;  font-family: Comic Sans MS, Textile, cursive; font-weight: bold;">
                      Regards.<br>
                      The Online Gurukul
                      </p>
                      </td>
                      </tr>
                      </table>
                      </td>
                      </tr>
                      <tr>
                      <td height="4" bgcolor="#ffa50070" class="contents" style="width:100%; border-top-left-radius:0px; border-top-right-radius:0px"></td>
                      </tr>
                      <tr>
                       <td height="65" align="center" class="header-cell" style="padding-top:7px; padding-bottom:7px; background-image:url('.$link1.')">
                      <center><span class="email-cos" style="font-size: 14px; color: #ffa500; font-weight: bolder;">Email :</span>
                      <a class="txs" href="mailto:helpdesk@theonlinegurukul.com" style="color:#000;  font-size:17px;text-decoration:none;" target="_blank">helpdesk@theonlinegurukul.com </a>
                      <br>
                      <span class="email-cos" style="font-size: 14px; color: #ffa500; font-weight: bolder;">Phone :-</span>
                      <a class="txs" href="tel:+91-0124-4272441" style="color:#000;  font-size:17px;text-decoration:none;" target="_blank"> 91-0124-4272441</a>
                      </center>
                      </td>
                      <tr>
                      </tr>
                      </table>
                      </td>
                      </tr>
                      </table>
                      </center>
                      </td>
                      </tr>
                      </table>
                      </body>
                      </html>';

                $this->email->message($htmlContent);
                if ($this->email->send()) {
                    $this->session->set_flashdata('success', " Email verification mail sent to your account,Please verify  ");
                    return redirect('student/signin');
                }
                else{
                    //show_error($this->email->print_debugger());
                    $this->session->set_flashdata('danger', " Error in sending Verification Email,please contact Admin to verify your Email Address");
                    return redirect('student/signin');
                }
            }
        }
        else{
            $this->load->view('web/student-register',['category'=>$category,'country'=>$country]);
        }
        $this->load->view('web/footer');
    }

    public function password_check($str)
    {
        if (preg_match('#[0-9]#', $str) && preg_match('#[a-zA-Z]#', $str)) {
            return TRUE;
        }
        return FALSE;
    }
    public function file_check($str){
        $allowed_mime_type_arr = array('application/pdf','image/gif','image/jpeg','image/pjpeg','image/png','image/x-png');
        $mime = get_mime_by_extension($_FILES['screenshot_speed']['name']);
        if(isset($_FILES['screenshot_speed']['name']) && $_FILES['screenshot_speed']['name']!=""){
            if(in_array($mime, $allowed_mime_type_arr)){
                return true;
            }else{
                $this->form_validation->set_message('file_check', 'Please select only pdf/gif/jpg/png file.');
                return false;
            }
        }else{
            $this->form_validation->set_message('file_check', 'Please choose a screenshot of internet Speed  to upload.');
            return false;
        }
    }
    public function resume_check($str){
        $allowed_mime_type_arr = array('application/pdf','image/gif','image/jpeg','image/pjpeg','image/png','image/x-png');
        $mime = get_mime_by_extension($_FILES['upload_resume']['name']);
        if(isset($_FILES['upload_resume']['name']) && $_FILES['upload_resume']['name']!=""){
            if(in_array($mime, $allowed_mime_type_arr)){
                return true;
            }else{
                $this->form_validation->set_message('resume_check', 'Please select only pdf/gif/jpg/png file.');
                return false;
            }
        }else{
            $this->form_validation->set_message('resume_check', 'Please choose a resume/cv to upload.');
            return false;
        }
    }
    public function reg_teacher_other_qualification(){
        $this->load->helper('url');
        if($_POST){
            $d = json_encode($_POST,true);
            $insert_id	                             =		$this->common_model->insert_masteruser(array("first_name"=>"dacsdcs",'last_name'=>'asdas'));
            //return $d;
        }
        //echo "asdsa";
    }
    public function multiple_select_grade()
    {

        $choice = $_POST['love_to_teach_grade'];//$this->input->post("love_to_teach_grade");
        if(is_null($choice))
        {
            $choice = array();
        }
        $schoolGroups = implode(',', $choice);

        if($schoolGroups != '') {
            return true;
        } else {
            $this->form_validation->set_message('multiple_select_grade', 'You need to select a least one element');
            return false;
        }
    }
    public function multiple_select_boards()
    {
        $choice = $_POST['boards_you_can_handle'];//$this->input->post("boards_you_can_handle");
        if(is_null($choice))
        {
            $choice = array();
        }
        $schoolGroups = implode(',', $choice);

        if($schoolGroups != '') {
            return true;
        } else {
            $this->form_validation->set_message('multiple_select_boards', 'You need to select a least one element');
            return false;
        }
    }

    public function multiple_select_timing()
    {
        $choice = $_POST['available_timings'];//$this->input->post("available_timings");
        if(is_null($choice))
        {
            $choice = array();
        }
        $schoolGroups = implode(',', $choice);

        if($schoolGroups != '') {
            return true;
        } else {
            $this->form_validation->set_message('multiple_select_timing', 'You need to select a least one element');
            return false;
        }
    }
    public function teacher_signup_new(){

        $this->load->view('web/header',['title'=>'TEACHER SIGNUP :: TOG',"hits"=>$this->hits]);
        //echo "<pre>"; print_r($_POST);die;
        $this->form_validation->set_rules('email','Email Address','required|trim|xss_clean|callback_check_teacher');

        if($this->form_validation->run()){

            $first_name                             =		strtolower($this->input->post('first_name'));
            $last_name		                        =		strtolower($this->input->post('last_name'));
            $gender		                            =		strtolower($this->input->post('gender'));
            $date_of_birth			                =		strtolower($this->input->post('dob'));
            $email		                            =		strtolower($this->input->post('email'));
            $mobile		                            =		strtolower($this->input->post('mobile'));
            $password			                    =		strtolower($this->input->post('password'));
            // $last_name		                    =		strtolower($this->input->post('conf_password'));
            $country			                    =		strtolower($this->input->post('country'));
            $state			                        =		strtolower($this->input->post('state'));
            $city			                        =		strtolower($this->input->post('city'));
            $zip_code			                    =		strtolower($this->input->post('zip_code'));
            $aadhar_id			                    =		strtolower($this->input->post('aadhar_id'));
            $pan_id			                        =		strtolower($this->input->post('pan_id'));

            $primary_qualification1			        =		strtolower($this->input->post('primary_qualification1'));
            $university1	                        =		strtolower($this->input->post('university1'));
            $year_of_passing1	                    =		strtolower($this->input->post('year_of_passing1'));
            $grade_percentage1	                    =		strtolower($this->input->post('grade_percentage1'));

            $primary_qualification2			        =		strtolower($this->input->post('primary_qualification2'));
            $university2	                        =		strtolower($this->input->post('university2'));
            $year_of_passing2	                    =		strtolower($this->input->post('year_of_passing2'));
            $grade_percentage2	                    =		strtolower($this->input->post('grade_percentage2'));

            $primary_qualification3			        =		strtolower($this->input->post('primary_qualification3'));
            $university3	                        =		strtolower($this->input->post('university3'));
            $year_of_passing3	                    =		strtolower($this->input->post('year_of_passing3'));
            $grade_percentage3	                    =		strtolower($this->input->post('grade_percentage3'));

            $primary_qualification4			        =		strtolower($this->input->post('primary_qualification4'));
            $university4	                        =		strtolower($this->input->post('university4'));
            $year_of_passing4	                    =		strtolower($this->input->post('year_of_passing4'));
            $grade_percentage4	                    =		strtolower($this->input->post('grade_percentage4'));

            $primary_qualification5			        =		strtolower($this->input->post('primary_qualification5'));
            $university5	                        =		strtolower($this->input->post('university5'));
            $year_of_passing5	                    =		strtolower($this->input->post('year_of_passing5'));
            $grade_percentage5	                    =		strtolower($this->input->post('grade_percentage5'));


            $pre_classes			                =		strtolower($this->input->post('pre_classes'));
            $primary_subject	                    =		strtolower(implode(",",$_POST['primary_subject']));
            $secondary_subject	                    =		strtolower(implode(",",$_POST['secondary_subject']));
            $pre_classes_other	                    =		strtolower($this->input->post('others'));

            $pre_classes2			                =		strtolower($this->input->post('pre_classes2'));
            $primary_subject2	                    =		strtolower(implode(",",$_POST['primary_subject2']));
            $secondary_subject2	                    =		strtolower(implode(",",$_POST['secondary_subject2']));
            $pre_classes_other2	                    =		strtolower($this->input->post('others2'));

            $pre_classes3			                =		strtolower($this->input->post('pre_classes3'));
            $primary_subject3	                    =		strtolower(implode(",",$_POST['primary_subject3']));
            $secondary_subject3	                    =		strtolower(implode(",",$_POST['secondary_subject3']));
            $pre_classes_other3	                    =		strtolower($this->input->post('others3'));

            $pre_classes4			                =		strtolower($this->input->post('pre_classes4'));
            $primary_subject4	                    =		strtolower(implode(",",$_POST['primary_subject4']));
            $secondary_subject4	                    =		strtolower(implode(",",$_POST['secondary_subject4']));
            $pre_classes_other4	                    =		strtolower($this->input->post('others4'));

            $pre_classes5			                =		strtolower($this->input->post('pre_classes5'));
            $primary_subject5	                    =		strtolower(implode(",",$_POST['primary_subject5']));
            $secondary_subject5	                    =		strtolower(implode(",",$_POST['secondary_subject5']));
            $pre_classes_other5	                    =		strtolower($this->input->post('others5'));

            $bank_name			                    =		strtolower($this->input->post('bank_name'));
            $branch_name			                =		strtolower($this->input->post('branch_name'));
            $account_holder_name			        =		strtolower($this->input->post('account_holder_name'));
            $account_no			                    =		strtolower($this->input->post('account_no'));
            $ifsc_code			                    =		strtolower($this->input->post('ifsc_code'));
            $micr_code			                    =		strtolower($this->input->post('micr_code'));

            $current_occupation			            =		strtolower($this->input->post('current_occupation'));
            $days_available			                =		strtolower(implode(",",$_POST['days_available']));
            $hours_week_ends_available			    =		strtolower($this->input->post('hours_week_ends_available'));
            $available_timings			            =		strtolower(implode(",",$_POST['available_timings']));
            $total_teaching_experience			    =		strtolower($this->input->post('total_teaching_experience'));

            $type_of_connection			            =		strtolower($this->input->post('type_of_connection'));
            $down_internet_conn_speed			    =		strtolower($this->input->post('down_internet_conn_speed'));
            $up_internet_conn_speed			        =		strtolower($this->input->post('up_internet_conn_speed'));
            $association_with_gurukul			    =		strtolower($this->input->post('association_with_gurukul'));
            $come_to_know_tog			            =		strtolower($this->input->post('come_to_know_tog_status'));
            //$tell_me_more			                =		strtolower($this->input->post('tell_me_more'));


            $hash 			                        = 		$this->bcrypt->hash_password($password);
            $hashtag		                        =		random_string('alnum', 16);



            $data			                         =		array('first_name'=> strtolower($first_name),'last_name'=> strtolower($last_name),
                'mobile'=>strtolower($mobile),'email'=>strtolower($email),'password'=>$hash,'category'=>'1','hashtag'=>$hashtag,
                'gender'=>$gender
            );
            $insert_id	                             =		$this->common_model->insert_masteruser($data);

            $data_basic			                     =		array('user_id'=>$insert_id,'dob'=> strtolower($date_of_birth),
                'country_id'=> strtolower($country),'state_id'=>strtolower($state),'city_id'=>strtolower($city),'zip_code'=>$zip_code,
                'aadhar_id'=>$aadhar_id,'pan_id'=>$pan_id);
            $insert_id_basic	                     =		$this->common_model->insert_mu_teacher_basic($data_basic);

           // if($primary_qualification1!=""){
                $data_qual1		                     =		array('user_id'=>$insert_id,'qualification'=> strtolower($primary_qualification1),
                    'university'=> strtolower($university1),'passing_year'=>strtolower($year_of_passing1),'grade'=>strtolower($grade_percentage1));
                $insert_id_qual1	                     =		$this->common_model->insert_mu_teacher_qualfication($data_qual1);
           // }
           // if($primary_qualification2!=""){
                $data_qual2		                     =		array('user_id'=>$insert_id,'qualification'=> strtolower($primary_qualification2),
                    'university'=> strtolower($university2),'passing_year'=>strtolower($year_of_passing2),'grade'=>strtolower($grade_percentage2));
                $insert_id_qual2	                     =		$this->common_model->insert_mu_teacher_qualfication($data_qual2);
           // }
           // if($primary_qualification3!=""){
                $data_qual3		                     =		array('user_id'=>$insert_id,'qualification'=> strtolower($primary_qualification3),
                    'university'=> strtolower($university3),'passing_year'=>strtolower($year_of_passing3),'grade'=>strtolower($grade_percentage3));
                $insert_id_qual3	                     =		$this->common_model->insert_mu_teacher_qualfication($data_qual3);
          //  }
           // if($primary_qualification4!=""){
                $data_qual4		                     =		array('user_id'=>$insert_id,'qualification'=> strtolower($primary_qualification4),
                    'university'=> strtolower($university4),'passing_year'=>strtolower($year_of_passing4),'grade'=>strtolower($grade_percentage4));
                $insert_id_qual4	                     =		$this->common_model->insert_mu_teacher_qualfication($data_qual4);
          //  }
           // if($primary_qualification5!=""){
                $data_qual5		                     =		array('user_id'=>$insert_id,'qualification'=> strtolower($primary_qualification5),
                    'university'=> strtolower($university5),'passing_year'=>strtolower($year_of_passing5),'grade'=>strtolower($grade_percentage5));
                $insert_id_qual5	                     =		$this->common_model->insert_mu_teacher_qualfication($data_qual5);
           // }


           // if($pre_classes!=""){
                $data_pf1			                  =		array('user_id'=>$insert_id,'class'=> strtolower($pre_classes),
                    'primary_sub'=> strtolower($primary_subject),'secondary_sub'=>strtolower($secondary_subject),
                    'other'=>strtolower($pre_classes_other));
                $insert_id_pf1	                      =		$this->common_model->insert_mu_teacher_pf_class($data_pf1);
           // }
            //if($pre_classes2!=""){
                $data_pf2			                  =		array('user_id'=>$insert_id,'class'=> strtolower($pre_classes2),
                    'primary_sub'=> strtolower($primary_subject2),'secondary_sub'=>strtolower($secondary_subject2),
                    'other'=>strtolower($pre_classes_other2));
                $insert_id_pf2	                      =		$this->common_model->insert_mu_teacher_pf_class($data_pf2);
           // }
           // if($pre_classes3!=""){
                $data_pf3			                  =		array('user_id'=>$insert_id,'class'=> strtolower($pre_classes3),
                    'primary_sub'=> strtolower($primary_subject3),'secondary_sub'=>strtolower($secondary_subject3),
                    'other'=>strtolower($pre_classes_other3));
                $insert_id_pf3	                      =		$this->common_model->insert_mu_teacher_pf_class($data_pf3);
           // }
           // if($pre_classes4!=""){
                $data_pf4			                  =		array('user_id'=>$insert_id,'class'=> strtolower($pre_classes4),
                    'primary_sub'=> strtolower($primary_subject4),'secondary_sub'=>strtolower($secondary_subject4),
                    'other'=>strtolower($pre_classes_other4));
                $insert_id_pf4	                      =		$this->common_model->insert_mu_teacher_pf_class($data_pf4);
           // }
           // if($pre_classes5!=""){
                $data_pf5			                  =		array('user_id'=>$insert_id,'class'=> strtolower($pre_classes5),
                    'primary_sub'=> strtolower($primary_subject5),'secondary_sub'=>strtolower($secondary_subject5),
                    'other'=>strtolower($pre_classes_other5));
                $insert_id_pf5	                      =		$this->common_model->insert_mu_teacher_pf_class($data_pf5);
           // }

            $data_bank			                         =		array('user_id'=>$insert_id,'bank_name'=> strtolower($bank_name),
                'branch_name'=> strtolower($branch_name),'account_holder_name'=>strtolower($account_holder_name),
                'account_no'=>strtolower($account_no),'ifsc_code'=>$ifsc_code,
                'micr_code'=>$micr_code);
            $insert_id_bank	                         =		$this->common_model->insert_mu_teacher_bank_detail($data_bank);

            $data_extra			                         =		array('user_id'=>$insert_id,'current_occupation'=> strtolower($current_occupation),
                'days_available'=> strtolower($days_available),'hours_week_ends_available'=>strtolower($hours_week_ends_available),
                'available_timings'=>strtolower($available_timings),
                'total_teaching_experience'=>$total_teaching_experience,
                'type_of_connection'=>$type_of_connection,'down_internet_conn_speed'=>$down_internet_conn_speed,
                "up_internet_conn_speed"=>$up_internet_conn_speed,'association_with_gurukul'=>$association_with_gurukul,
                'come_to_know_tog_status'=>$come_to_know_tog
            );
            $insert_id_extra	                     =		$this->common_model->insert_mu_teacher_extra_info($data_extra);

           // $user_info                               =      $this->common_model->select_profile_info($insert_id);


            if($this->input->post('fileSubmit') && !empty($_FILES['upload_profile_pic']['name'])){
                $_FILES['upload_profile_pic']['name']        = 	$_FILES['upload_profile_pic']['name'];
                $_FILES['upload_profile_pic']['type']        = 	$_FILES['upload_profile_pic']['type'];
                $_FILES['upload_profile_pic']['tmp_name']    = 	$_FILES['upload_profile_pic']['tmp_name'];
                $_FILES['upload_profile_pic']['error']       = 	$_FILES['upload_profile_pic']['error'];
                $_FILES['upload_profile_pic']['size']        = 	$_FILES['upload_profile_pic']['size'];

                $uploadPath 					        = 	"./uploads/user/images/$insert_id/profile/";
                if(!is_dir($uploadPath )){mkdir($uploadPath, 0777, TRUE );}
                $config['upload_path'] 			        = 	$uploadPath;
                $config['allowed_types'] 		        = 	'jpg|png|gif|jpeg|JPG|PNG|GIF|pdf|doc|txt';
                $config['overwrite'] 			        = 	'1';

                $this->load->library('upload', $config);
                $this->upload->initialize($config);

                if($this->upload->do_upload('upload_profile_pic')){
                    $fileData = $this->upload->data();
                   // $res['profile']['profile_pic']           =   $config['upload_path'].$fileData['file_name'];
                    //$res1                                   =   json_encode($res);
                    //$this->common_model->update_profile($insert_id,$res1);
                    $this->common_model->update_profile_master_user($insert_id,'profile_image', $config['upload_path'].$fileData['file_name']);

                }
            }

            if($this->input->post('fileSubmit') && !empty($_FILES['screenshot_speed']['name'])){

                $_FILES['screenshot_speed']['name'] 	= 	$_FILES['screenshot_speed']['name'];
                $_FILES['screenshot_speed']['type'] 	= 	$_FILES['screenshot_speed']['type'];
                $_FILES['screenshot_speed']['tmp_name'] = 	$_FILES['screenshot_speed']['tmp_name'];
                $_FILES['screenshot_speed']['error'] 	= 	$_FILES['screenshot_speed']['error'];
                $_FILES['screenshot_speed']['size']     = 	$_FILES['screenshot_speed']['size'];

                $uploadPath 					        = 	"./uploads/user/images/$insert_id/screenshot/";
                if(!is_dir($uploadPath )){mkdir($uploadPath, 0777, TRUE );}
                $config['upload_path'] 			        = 	$uploadPath;
                $config['allowed_types'] 		        = 	'jpg|png|gif|jpeg|JPG|PNG|GIF';
                $config['overwrite'] 			        = 	'1';

                $this->load->library('upload', $config);
                $this->upload->initialize($config);

                if($this->upload->do_upload('screenshot_speed')){
                    $fileData                           =   $this->upload->data();
                   // $res['profile']['screenshot']       =   $config['upload_path'].$fileData['file_name'];
                    //$res1                               =   json_encode($res);
                   // $this->common_model->update_profile($insert_id,$res1);
                    $this->common_model->update_profile_mu_teacher_basic($insert_id,'screenshot_speed',$config['upload_path'].$fileData['file_name']);
                }
            }
            if($this->input->post('fileSubmit') && !empty($_FILES['upload_resume']['name'])){
                $_FILES['upload_resume']['name']        = 	$_FILES['upload_resume']['name'];
                $_FILES['upload_resume']['type']        = 	$_FILES['upload_resume']['type'];
                $_FILES['upload_resume']['tmp_name']    = 	$_FILES['upload_resume']['tmp_name'];
                $_FILES['upload_resume']['error']       = 	$_FILES['upload_resume']['error'];
                $_FILES['upload_resume']['size']        = 	$_FILES['upload_resume']['size'];

                $uploadPath 					        = 	"./uploads/user/images/$insert_id/resume/";
                if(!is_dir($uploadPath )){mkdir($uploadPath, 0777, TRUE );}
                $config['upload_path'] 			        = 	$uploadPath;
                $config['allowed_types'] 		        = 	'jpg|png|gif|jpeg|JPG|PNG|GIF|pdf|doc|txt';
                $config['overwrite'] 			        = 	'1';

                $this->load->library('upload', $config);
                $this->upload->initialize($config);

                if($this->upload->do_upload('upload_resume')){
                    $fileData = $this->upload->data();
                    //$res['profile']['resume']           =   $config['upload_path'].$fileData['file_name'];
                   // $res1                               =   json_encode($res);
                    //$this->common_model->update_profile($insert_id,$res1);
                    $this->common_model->update_profile_mu_teacher_basic($insert_id,'upload_resume',$config['upload_path'].$fileData['file_name']);
                }
            }

            if($insert_id!==""){
                $config['mailtype']     = 'html';
                $this->email->initialize($config);
                $this->email->from('helpdesk@theonlinegurukul.com', 'theOnlineGurukul Pvt. Ltd.');
                //$this->email->to(['narender.rathore@deconglobalsolutions.com','narender.rathore@theonlinegurukul.com']);
                $this->email->to($email);
                $this->email->subject('Email Account Verification - TOG  Admin');
                $salthash		=		random_string('alnum', 9);
                $link1          =  base_url("assets/web/images/bg-email.png");
                $link2          =  base_url("assets/web/images/bg-footer.png");

                $htmlContent = '
                   <!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
                    <html xmlns="http://www.w3.org/1999/xhtml">
                    <head>
                      <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
                      <meta name="viewport" content="width=device-width, initial-scale=1" />
                      <title>TOG ACCOUNT ACTIVATION LINK</title>
                      <style type="text/css" media="screen">

                        /* Force Hotmail to display emails at full width */
                        .ExternalClass {
                          display: block !important;
                          width: 100%;
                        }

                        /* Force Hotmail to display normal line spacing */
                        .ExternalClass,
                        .ExternalClass p,
                        .ExternalClass span,
                        .ExternalClass font,
                        .ExternalClass td,
                        .ExternalClass div {
                          line-height: 100%;
                        }

                        body,
                        p,
                        h1,
                        h2,
                        h3,
                        h4,
                        h5,
                        h6 {
                          margin: 0;
                          padding: 0;
                        }

                        body,
                        p,
                        td {
                          font-family: Arial, Helvetica, sans-serif;
                          font-size: 15px;
                          color: #333333;
                          line-height: 1.5em;
                        }

                        h1 {
                            text-align: center;
                        font-size: 20px;
                        font-weight: bold;
                        line-height: 24px;
                        }

                        body,
                        p {
                          margin-bottom: 0;
                          -webkit-text-size-adjust: none;
                          -ms-text-size-adjust: none;
                        }

                        img {
                          outline: none;
                          text-decoration: none;
                          -ms-interpolation-mode: bicubic;
                        }

                        a img {
                          border: none;
                        }

                        .background {
                                    background-color: #eeeeee;
                    }


                        table.background {
                          margin: 0;
                          padding: 0;
                          width: 100% !important;
                        }

                        .block-img {
                          display: block;
                          line-height: 0;
                        }

                        a {
                          color: white;
                          text-decoration: none;
                        }

                        a,
                        a:link {
                          color: #2A5DB0;
                          text-decoration: underline;
                        }

                        table td {
                          border-collapse: collapse;
                        }

                        td {
                          vertical-align: top;
                          text-align: left;
                        }

                        .wrap {
                    	    margin-top: 0px;
                          width: 600px;
                        }

                        .wrap-cell {
                          padding-top: 30px;
                          padding-bottom: 30px;
                        }

                        .header-cell,
                        .body-cell,
                        .footer-cell {
                          padding-left: 20px;
                          padding-right: 20px;
                        }

                        .header-cell {


                          color: #ffffff;
                        }

                        .body-cell {
                          background-color: #ffffff;
                          padding-top:16px;
                          padding-bottom: 34px;
                        }

                        .footer-cell {

                          text-align: center;
                          font-size: 13px;
                          padding-top:13px;
                          padding-bottom: 30px;
                        }

                        .card {
                          width: 400px;
                          margin: 0 auto;
                        }

                        .data-heading {
                          text-align: right;
                          padding: 10px;
                          background-color: #ffffff;
                          font-weight: bold;
                        }

                        .data-value {
                          text-align: left;
                          padding: 10px;
                          background-color: #ffffff;
                        }

                        .force-full-width {
                          width: 100% !important;
                        }

                      </style>
                      <style type="text/css" media="only screen and (max-width: 600px)">
                        @media only screen and (max-width: 600px) {
                          body[class*="background"],
                          table[class*="background"],
                          td[class*="background"] {
                            background: #eeeeee !important;
                          }

                          table[class="card"] {
                            width: auto !important;
                          }

                          td[class="data-heading"],
                          td[class="data-value"] {
                            display: block !important;
                          }

                          td[class="data-heading"] {
                            text-align: left !important;
                            padding: 10px 10px 0;
                          }

                          table[class="wrap"] {
                            width: 100% !important;
                          }

                          td[class="wrap-cell"] {
                            padding-top: 0 !important;
                            padding-bottom: 0 !important;
                          }
                        }


                      </style>
                    </head>

            <body leftmargin="0" marginwidth="0" topmargin="0" marginheight="0" offset="0" bgcolor="" class="background">
              <table align="center" border="0" cellpadding="0" cellspacing="0" height="100%" width="100%" class="background">
                <tr>
                  <td align="center" valign="top" width="100%" class="background">
                    <center>
                      <table cellpadding="0" cellspacing="0" width="600" class="wrap">
                        <tr>
                          <td valign="top" class="wrap-cell" style="padding-top:30px; padding-bottom:30px;">
                            <table cellpadding="0" cellspacing="0" class="force-full-width">
            				 <tr>
                                <td height="8" bgcolor="#ededed" class="contents" style="width:100%; border-top-left-radius:0px; border-top-right-radius:0px"></td>
                              </tr>
                              <tr>
                               <td height="65" valign="top" class="header-cell" style="padding-top:7px; padding-bottom:7px; background-image:url('.$link1.')">
                               <a href="http://theonlinegurukul.com" target="_blank">
                               <img src="'.base_url("assets/web/images/20.png").'" width="150"  alt="" style="border-width:0; max-width:100px; display:block" /></a>
                               </td>
                               </tr>
                               <tr>
                               <td height="4" bgcolor="#ffa50070" class="contents" style="width:100%; border-top-left-radius:0px; border-top-right-radius:0px"><!--  border-top-left-radius:10px; --> <!-- border-top-right-radius:10px" --></td>
                                                      </tr>

                              <tr>
                                <td valign="top" class="body-cell">

                                  <table cellpadding="0" cellspacing="0" width="100%" bgcolor="#ffffff">
                                  <tr>
                                  <td valign="top" style="padding-bottom:15px; background-color:#ffffff;">
                                  <h1>User Email Address verification link</h1>
                                  </td>
                                  </tr>
                                  <tr>
                                  <td valign="top" style="padding-bottom:20px; background-color:#ffffff;">
                                  <p style="color:#5b5f65; font-size:14px; text-align:justify; font-family: Verdana, Geneva, sans-serif">
                                  Your TOG Account activation link is as follows. Please click the link
            							  below to Activation of your Account.<br>
                                  </p>
                                  <center>    <a href="'.site_url("user/email/verify/").$hashtag.$insert_id.$salthash.'"
                                  style="background-color:#ffa500;color:#ffffff;display:inline-block;font-family:sans-serif;font-size: 16px;line-height:37px;text-align:center;text-decoration:none;width:165px;-webkit-text-size-adjust:none;">Verify your Account</a>
                                  </center>
                                  <br>
                                  <p style="color:#5b5f65; font-size:14px; text-align:justify;font-family: Verdana, Geneva, sans-serif">

                                  Thank you for your patience. Please contact us for any inconvenience caused to you.<br>


                                  </p>
                                  </td>
                                  </tr>
                                  <tr>
                                  <td>
                                  <table cellspacing="0" cellpadding="0" width="100%" bgcolor="#ffffff">
                                  <tr>
                                  <td style="width:200px;background:#008000;">
                                  <div><!--[if mso]>
                                  <v:rect xmlns:v="urn:schemas-microsoft-com:vml" xmlns:w="urn:schemas-microsoft-com:office:word" href="#" style="height:40px;v-text-anchor:middle;width:200px;" stroke="f" fillcolor="#008000">
                                  <w:anchorlock/>
                                  <center>
                                  <![endif]-->


                                  <!--[if mso]>
                                  </center>
                                  </v:rect>
                                  <![endif]--></div>
                                  </td>
                                  <td width="360" style="background-color:#ffffff; font-size:0; line-height:0;">&nbsp;</td>
                                  </tr>
                                  </table>
                                  </td>
                                  </tr>
                                  <tr>
                                  <td style="padding-top:20px;background-color:#ffffff;">
                                  <p style="color:black;  font-family: Comic Sans MS, Textile, cursive; font-weight: bold;">

                                  Regards.<br>
                                  The Online Gurukul
                                  </p>
                                  </td>
                                  </tr>
                                  </table>
                                  </td>
                                  </tr>
                                  <tr>
                                  <td height="4" bgcolor="#ffa50070" class="contents" style="width:100%; border-top-left-radius:0px; border-top-right-radius:0px"></td>
                                  </tr>

                                  <tr>
                                   <td height="65" align="center" class="header-cell" style="padding-top:7px; padding-bottom:7px; background-image:url('.$link1.')">

                                  <center><span class="email-cos" style="font-size: 14px; color: #ffa500; font-weight: bolder;">Email :</span>
                                  <a class="txs" href="mailto:helpdesk@theonlinegurukul.com" style="color:#000;  font-size:17px;text-decoration:none;" target="_blank">helpdesk@theonlinegurukul.com </a>
                                  <br>
                                  <span class="email-cos" style="font-size: 14px; color: #ffa500; font-weight: bolder;">Phone :-</span>
                                  <a class="txs" href="tel:+91-0124-4272441" style="color:#000;  font-size:17px;text-decoration:none;" target="_blank"> 91-0124-4272441</a>
                                  </center>
                                  </td>
                                  <tr>

                                  </tr>



                                  </table>
                                  </td>
                                  </tr>
                                  </table>
                                  </center>
                                  </td>
                                  </tr>
                                  </table>

                                  </body>
                                  </html>

        ';

                $this->email->message($htmlContent);

                if ($this->email->send()) {
                    $this->session->set_flashdata('success', " Email verification mail sent to your account,Please verify  ");
                    return redirect('teacher/signin');
                }
                else{
                    //show_error($this->email->print_debugger());
                    $this->session->set_flashdata('danger', " Error in sending Verification Email,please contact Admin to verify your Email Address");
                    return redirect('teacher/signin');
                }
            }

            /*$this->session->set_flashdata('success', " You are  Registered Successfully");
             $this->session->set_flashdata('danger',  " Error Occured in Registration");
             return redirect('teacher/signin');
             */

        }else{
            $country1       = $this->common_model->getCountry();
            $qualification  = $this->common_model->select_qualification_listing();
            $subject        = $this->common_model->select_subject_listing();
            //$data['cities'] = $this->Main_model->getCity();
            $this->load->view('web/teachersignup_new',['country'=>$country1,'qualification'=>$qualification,
            'subject'=>$subject]);
            }
            $this->load->view('web/footer2');
     }


    function check_user() {

        $email 			= 	strtolower(trim($this->input->post('email')));// get fiest name
        $category 		= 	"2";
        $query			=	$this->db->select('email')->from('master_user')->where('email', $email)
        ->where('category', $category)->get();
        $num 			= 	$query->num_rows();
        $query2			=	$this->db->select('category')->from('user_category')->where('id', $category)->get();
        $query2			=	$query2->row();
        $category_name	=	strtoupper($query2->category);
        if ($num > 0) {
            //$this->form_validation->set_message('check_user',"The {field} field you are already registerd with us as{$category_name} => {$email}");
            $this->form_validation->set_message('check_user',"This email already registered with us as a Student");
            return FALSE;
        }
        else {
            return TRUE;
        }
    }
    function check_teacher() {

        $email 			= 	strtolower(trim($this->input->post('email')));// get fiest name

        $query			=	$this->db->select('email')->from('master_user')->where('email', $email)
        ->where('category', '1')->get();
        $num 			= 	$query->num_rows();
        $query2			=	$this->db->select('category')->from('user_category')->where('id', $category)->get();
        $query2			=	$query2->row();
        $category_name	=	strtoupper($query2->category);
        if ($num > 0) {
            //$this->form_validation->set_message('check_teacher',"The {field} field you are already registerd with us as{$category_name} => {$email}");
            $this->form_validation->set_message('check_teacher',"This email already registered with us as a Teacher");
            return FALSE;
        }
        else {
            return TRUE;
        }
    }
    function check_teacher2() {

        $email 			= 	strtolower(trim($this->input->post('email')));// get fiest name

        $query			=	$this->db->select('email')->from('master_user')->where('email', $email)
        ->where('category', '1')->get();
        $num 			= 	$query->num_rows();

        if ($num > 0) {
            echo "Email already exist as teacher profile";
            //echo "<script>alert('User Name Already Exist');</script>";
        }
        else {
            //echo "<script>alert('OK');</script>";
            //echo "OK";
        }
        exit();
    }


    public function admin_login(){

        $this->form_validation->set_rules('email','Email','required|trim|xss_clean|valid_email');
        $this->form_validation->set_rules('password','Password','required|xss_clean|trim');
        if($this->session->userdata('ss_id')){return redirect('Student');}
        if($this->session->userdata('ts_id')){return redirect('Teacher');}
        if($this->session->userdata('ad_id')){return redirect('Admin');}
        if($this->form_validation->run()){
            $email			=		strtolower(trim($this->input->post('email')));
            $password		=		$this->input->post('password');
            $login			=		$this->adminlte_model->login_valid($email);
            //$hash 		= 	$this->bcrypt->hash_password($password);
            if($this->bcrypt->check_password($password, $login->password)){
                $this->load->library('session');
                $this->session->set_userdata('ad_id',$login->id);
                //echo $this->session->userdata('ad_id');die;
                return redirect('admin/Adminlte');
            }
            else{
                $this->session->set_flashdata('danger','Invalid Username/Password');
                return redirect('Admin/signin');
            }
        }
        else{
            $this->load->view('adminlte/user_login');
        }
    }
    public function testmail(){
        $this->load->library('email');

        $config['mailtype'] = 'html';

        $this->email->initialize($config);
        $this->email->from('helpdek@theonlinegurukul.com', 'theOnlineGurukul Pvt. Ltd.');
        //$this->email->from('nrathore.web@gmail.com', 'theonlinegurukul Pvt. Ltd.');
        $this->email->to(['narender.rathore@deconglobalsolutions.com','narender.rathore@theonlinegurukul.com']);


      //  $this->email->cc(['lava.prasad@deconglobalsolutions.com','atul.jain@deconglobalsolutions.com','somesh.mittal@deconglobalsolutions.com']);
        //$this->email->bcc(['harbans.yadav@deconindia.com','swatentra.singh@deconindia.com','neha.srivastava@deconindia.com']);
        $this->email->subject('Test Mail - Email Config- TOG');

        $htmlContent = 'Hello,<br><br>';
        $htmlContent .= 'Greetings From Helpdesk theonlinegurukul<br><br>';
        $htmlContent .= '<p>Mail service configuration done </p><br><br>';
       $d=  "Narender-who";
        $htmlContent .= '


            <!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
            <html xmlns="http://www.w3.org/1999/xhtml">
            <head>
            <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
            <!--[if !mso]><!-->
            <meta http-equiv="X-UA-Compatible" content="IE=edge" />
            <!--<![endif]-->
            <meta name="viewport" content="width=device-width, initial-scale=1.0" />
            <title></title>
            <style type="text/css">
            * {
            	-webkit-font-smoothing: antialiased;
            }
            body {
            	Margin: 0;
            	padding: 0;
            	min-width: 100%;
            	font-family: Arial, sans-serif;
            	-webkit-font-smoothing: antialiased;
            	mso-line-height-rule: exactly;
            }
            table {
            	border-spacing: 0;
            	color: #333333;
            	font-family: Arial, sans-serif;
            }
            img {
            	border: 0;
            }
            .wrapper {
            	width: 100%;
            	table-layout: fixed;
            	-webkit-text-size-adjust: 100%;
            	-ms-text-size-adjust: 100%;
            }
            .webkit {
            	max-width: 600px;
            }
            .outer {
            	Margin: 0 auto;
            	width: 100%;
            	max-width: 600px;
            }
            .full-width-image img {
            	width: 100%;
            	max-width: 600px;
            	height: auto;
            }
            .inner {
            	padding: 10px;
            }
            p {
            	Margin: 0;
            	padding-bottom: 10px;
            }
            .h1 {
            	font-size: 21px;
            	font-weight: bold;
            	Margin-top: 15px;
            	Margin-bottom: 5px;
            	font-family: Arial, sans-serif;
            	-webkit-font-smoothing: antialiased;
            }
            .h2 {
            	font-size: 18px;
            	font-weight: bold;
            	Margin-top: 10px;
            	Margin-bottom: 5px;
            	font-family: Arial, sans-serif;
            	-webkit-font-smoothing: antialiased;
            }
            .one-column .contents {
            	text-align: left;
            	font-family: Arial, sans-serif;
            	-webkit-font-smoothing: antialiased;
            }
            .one-column p {
            	font-size: 14px;
            	Margin-bottom: 10px;
            	font-family: Arial, sans-serif;
            	-webkit-font-smoothing: antialiased;
            }
            .two-column {
            	text-align: center;
            	font-size: 0;
            }
            .two-column .column {
            	width: 100%;
            	max-width: 300px;
            	display: inline-block;
            	vertical-align: top;
            }
            .contents {
            	width: 100%;
            }
            .two-column .contents {
            	font-size: 14px;
            	text-align: left;
            }
            .two-column img {
            	width: 100%;
            	max-width: 280px;
            	height: auto;
            }
            .two-column .text {
            	padding-top: 10px;
            }
            .three-column {
            	text-align: center;
            	font-size: 0;
            	padding-top: 10px;
            	padding-bottom: 10px;
            }
            .three-column .column {
            	width: 100%;
            	max-width: 200px;
            	display: inline-block;
            	vertical-align: top;
            }
            .three-column .contents {
            	font-size: 14px;
            	text-align: center;
            }
            .three-column img {
            	width: 100%;
            	max-width: 180px;
            	height: auto;
            }
            .three-column .text {
            	padding-top: 10px;
            }
            .img-align-vertical img {
            	display: inline-block;
            	vertical-align: middle;
            }
            @media only screen and (max-device-width: 480px) {
            table[class=hide], img[class=hide], td[class=hide] {
            	display: none !important;
            }
            </style>
            <!--[if (gte mso 9)|(IE)]>
            	<style type="text/css">
            		table {border-collapse: collapse !important;}
            	</style>
            	<![endif]-->
            </head>

            <body style="Margin:0;padding-top:0;padding-bottom:0;padding-right:0;padding-left:0;min-width:100%;background-color:#ececec;">
            <center class="wrapper" style="width:100%;table-layout:fixed;-webkit-text-size-adjust:100%;-ms-text-size-adjust:100%;background-color:#ececec;">
              <table width="100%" cellpadding="0" cellspacing="0" border="0" style="background-color:#ececec;" bgcolor="#ececec;">
                <tr>
                  <td width="100%"><div class="webkit" style="max-width:600px;Margin:0 auto;">

                      <!--[if (gte mso 9)|(IE)]>

            						<table width="600" align="center" cellpadding="0" cellspacing="0" border="0" style="border-spacing:0" >
            							<tr>
            								<td style="padding-top:0;padding-bottom:0;padding-right:0;padding-left:0;" >
            								<![endif]-->

                      <!-- ======= start main body ======= -->
                      <table class="outer" align="center" cellpadding="0" cellspacing="0" border="0" style="border-spacing:0;Margin:0 auto;width:100%;max-width:600px;">
                        <tr>
                          <td style="padding-top:0;padding-bottom:0;padding-right:0;padding-left:0;"><!-- ======= start header ======= -->

                            <table border="0" width="100%" cellpadding="0" cellspacing="0"  >
                              <tr>
                                <td><table style="width:100%;" cellpadding="0" cellspacing="0" border="0">
                                    <tbody>
                                      <tr>
                                        <td align="center"><center>
                                            <table border="0" align="center" width="100%" cellpadding="0" cellspacing="0" style="Margin: 0 auto;">
                                              <tbody>
                                                <tr>
                                                  <td class="one-column" style="padding-top:0;padding-bottom:0;padding-right:0;padding-left:0;"><table border="0" cellpadding="0" cellspacing="0" width="100%" style="border-spacing:0">
                                                      <tr>
                                                        <td>&nbsp;</td>
                                                      </tr>

                                                      <tr>
                                                        <td align="center">&nbsp;</td>
                                                      </tr>
                                                      <tr>
                                                        <td height="6" bgcolor="#ff7e65" class="contents" style="width:100%; border-top-left-radius:10px; border-top-right-radius:10px"></td>
                                                      </tr>
                                                    </table></td>
                                                </tr>
                                              </tbody>
                                            </table>
                                          </center></td>
                                      </tr>
                                    </tbody>
                                  </table></td>
                              </tr>
                            </table>
                            <table border="0" width="100%" cellpadding="0" cellspacing="0"  >
                              <tr>
                                <td><table style="width:100%;" cellpadding="0" cellspacing="0" border="0">
                                    <tbody>
                                      <tr>
                                        <td align="center"><center>
                                            <table border="0" align="center" width="100%" cellpadding="0" cellspacing="0" style="Margin: 0 auto;">
                                              <tbody>
                                                <tr>
                                                  <td class="one-column" style="padding-top:0;padding-bottom:0;padding-right:0;padding-left:0;" bgcolor="#FFFFFF"><!-- ======= start header ======= -->

                                                    <table cellpadding="0" cellspacing="0" border="0" width="100%">
                                                      <tr>
                                                        <td class="two-column" style="padding-top:0;padding-bottom:0;padding-right:0;padding-left:0;text-align:center;font-size:0;"><!--[if (gte mso 9)|(IE)]>
            													<table width="100%" style="border-spacing:0" >
            													<tr>
            													<td width="20%" valign="top" style="padding-top:0;padding-bottom:0;padding-right:0;padding-left:0;" >
            													<![endif]-->

                                                          <div class="column" style="width:100%;max-width:110px;display:inline-block;vertical-align:top;">
                                                            <table class="contents" style="border-spacing:0; width:100%"  bgcolor="#ffffff" >
                                                              <tr>
                                                                <td style="padding-top:0;padding-bottom:0;padding-right:0;padding-left:0;" align="left">
            													<a href="http://theonlinegurukul.com" target="_blank">'.$d.'</a></td>
                                                   </tr>
                                                            </table>
                                                          </div>

                                                          <!--[if (gte mso 9)|(IE)]>
            													</td><td width="80%" valign="top" style="padding-top:0;padding-bottom:0;padding-right:0;padding-left:0;" >
            													<![endif]-->

                                                          <div class="column" style="width:100%;max-width:415px;display:inline-block;vertical-align:top;">
                                                            <table width="100%" style="border-spacing:0" bgcolor="#ffffff">
                                                              <tr>
                                                                <td><table width="100%" border="0" cellspacing="0" cellpadding="0" class="hide">
                                                                    <tr>
                                                                      <td height="60">&nbsp;</td>
                                                                    </tr>
                                                                  </table></td>
                                                              </tr>
                                                              <tr>
                                                                <td class="inner" style="padding-top:10px;padding-bottom:10px; padding-right:10px;padding-left:10px;"><table class="contents" style="border-spacing:0; width:100%" bgcolor="#FFFFFF">

                                                                  </table></td>
                                                              </tr>
                                                            </table>
                                                          </div>

                                                          <!--[if (gte mso 9)|(IE)]>
            													</td>
            													</tr>
            													</table>
            													<![endif]--></td>
                                                      </tr>
                                                      <tr>
                                                        <td align="left" style="padding-left:40px"><table border="0" cellpadding="0" cellspacing="0" style="border-bottom:2px solid #ff7e65" align="left">
                                                            <tr>
                                                              <td height="20" width="30" style="font-size: 20px; line-height: 20px;">&nbsp;</td>
                                                            </tr>
                                                          </table></td>
                                                      </tr>
                                                      <tr>
                                                        <td>&nbsp;</td>
                                                      </tr>
                                                    </table></td>
                                                </tr>
                                              </tbody>
                                            </table>
                                          </center></td>
                                      </tr>
                                    </tbody>
                                  </table></td>
                              </tr>
                            </table>

                            <!-- ======= end header ======= -->

                            <!-- ======= start hero image ======= --><!-- ======= end hero image ======= -->

                            <!-- ======= start hero article ======= -->

                            <table class="one-column" border="0" cellpadding="0" cellspacing="0" width="100%" style="border-spacing:0" bgcolor="#FFFFFF">
                              <tr>
                                <td align="left" style="padding:0px 40px 40px 40px"><p style="color:#000; font-size:15px; text-align:left; font-weight:bold; font-family: Verdana, Geneva, sans-serif">
                                       Dear Student,</p>
                                  <p style="color:#5b5f65; font-size:14px; text-align:justify; font-family: Verdana, Geneva, sans-serif">We have received an online payment of 0.0$ for the orderID "xyz".
                                           You will get the notifications once your solution get ready.
                                    </p>

                                   <p style="color:#5b5f65; font-size:14px; text-align:justify; font-family: Verdana, Geneva, sans-serif">

                                 Thank you for choosing us.</br>

                                    </p>

                                  <p style="color:black;  font-family: Comic Sans MS, Textile, cursive; font-weight: bold;">

            					   Regards.<br/>
                                           Best Assignment Experts
                                          </p>
                                  <!-- START BUTTON -->


                                  </td>
                                  <!-- END BUTTON -->
                              </tr>
                            </table>


                            <!-- ======= end hero article ======= -->

                             <!-- ======= start footer ======= -->

                           <table width="100%" border="0" cellspacing="0" cellpadding="0">
                <tr>
                <td><table width="100%" cellpadding="0" cellspacing="0" border="0"  bgcolor="#ff7e65">
                  <tr>
                    <td height="40" align="center" bgcolor="#ff7e65" class="one-column">&nbsp;</td>
                  </tr>
                  <tr>
                    <td align="center" bgcolor="#ff7e65" class="one-column" style="padding-top:0;padding-bottom:0;padding-right:10px;padding-left:10px;">
            		<font style="font-size:13px; text-decoration:none; color:#fff; font-family: Verdana, Geneva, sans-serif; text-align:center">
            		<span>Email :-
            		<a class="txs" href="mailto: support@bestassigmentexperts.com" style="color:#fff; font-size:13px;text-decoration:none;"target="_blank"> support@bestassigmentexperts.com</a>
            		</span></br>
            		</font></td>
                  </tr>
            	  <tr>
                    <td align="center" bgcolor="#ff7e65" class="one-column" style="padding-top:0;padding-bottom:0;padding-right:10px;padding-left:10px;">
            		<font style="font-size:13px; color:#fff; font-family: Verdana, Geneva, sans-serif;">
            		<span>Phone :-
            		<a href="tel:+61-280065002" style="color:#fff; font-size:13px;text-decoration:none;" target="_blank">+61-280065002
            		</a>
            		</span></br>
            		</font></td>
                  </tr>



                  <tr>
                    <td align="center" bgcolor="#ff7e65" class="one-column" style="padding-top:0;padding-bottom:0;padding-right:0;padding-left:0;">&nbsp;</td>
                  </tr>
                  <tr>
                    <td align="center" bgcolor="#ff7e65" class="one-column" style="padding-top:0;padding-bottom:0;padding-right:0;padding-left:0;"><table width="150" border="0" cellspacing="0" cellpadding="0">
                      <tr>
                        <td width="33" align="center"><a href="https://www.facebook.com/bestassignmentexperts/" target="_blank"><img src="https://gallery.mailchimp.com/fdcaf86ecc5056741eb5cbc18/images/237854a9-0a06-4f88-a9b8-c36e57e31083.png" alt="facebook" width="32" height="32" border="0"/></a></td>
                        <td width="34" align="center"><a href="https://twitter.com/best_experts" target="_blank"><img src="https://gallery.mailchimp.com/fdcaf86ecc5056741eb5cbc18/images/2fb3f578-f70a-41b6-9bbc-f99a174d6456.png" alt="twitter" width="32" height="32" border="0"/></a></td>
                        <td width="33" align="center"><a href="https://plus.google.com/u/0/105218237372273771771" target="_blank"><img src="http://www.huayacan.com/img/social/google-plus.png" alt="google-plus" width="32" height="32" border="0"/></a></td>
                      </tr>
                    </table></td>
                  </tr>
                  <tr>
                    <td align="center" bgcolor="#ff7e65" class="one-column" style="padding-top:0;padding-bottom:0;padding-right:0;padding-left:0;">&nbsp;</td>
                  </tr>

                  <tr>
                    <td align="center" bgcolor="#ff7e65" class="one-column" style="padding-top:0;padding-bottom:0;padding-right:0;padding-left:0;">&nbsp;</td>
                  </tr>
                  <tr>
                    <td height="6" bgcolor="#ff7e65" class="contents1" style="width:100%; border-bottom-left-radius:10px; border-bottom-right-radius:10px"></td>
                  </tr>
                  </table></td>
              </tr>
              <tr>
                <td><table width="100%" cellpadding="0" cellspacing="0" border="0">
                  <tr>
                    <td height="6" bgcolor="#ff7e65" class="contents" style="width:100%; border-bottom-left-radius:10px; border-bottom-right-radius:10px"></td>
                  </tr>
                  <tr>
                    <td>&nbsp;</td>
                  </tr>
                </table></td>
              </tr>
            </table>

                           <!-- ======= end footer ======= --></td>
                        </tr>
                      </table>
                      <!--[if (gte mso 9)|(IE)]>
            					</td>
            				</tr>
            			</table>
            			<![endif]-->
                    </div></td>
                </tr>
              </table>
            </center>
            </body>
            </html>

        ';

        $this->email->message($htmlContent);
           //$this->email->attach("./uploads/email_attachment/{$projectcode}.xlsx");
        if ($this->email->send()) {
            echo "Your e-mail has been sent!";
            //$path    = "./uploads/email_attachment/";
            //array_map('unlink', glob("$path*.xlsx"));
        }
        else{
            show_error($this->email->print_debugger());
        }

    }

    public function teacher_forget_pass(){

        $this->load->view('web/header',['title'=>'TEACHER FORGET PASSWORD :: TOG',"hits"=>$this->hits]);
        $this->form_validation->set_error_delimiters('<p class="font-bold col-pink">', '</p>');
        $this->form_validation->set_rules('email','Email Address','required|trim|xss_clean|valid_email');

        if($this->form_validation->run()){
            $email			=		$this->input->post('email');
            $count			=		$this->common_model->login_valid_count($email,'1');

            if($count>0){
                $row        =       $this->common_model->login_valid($email,'1');
                $config['mailtype']     = 'html';
                $this->email->initialize($config);
                $this->email->from('helpdesk@theonlinegurukul.com', 'theOnlineGurukul Pvt. Ltd.');
                //$this->email->to(['narender.rathore@deconglobalsolutions.com','narender.rathore@theonlinegurukul.com']);
                $this->email->to($email);
                $this->email->subject('Account password reset - TOG  Admin');
                $salthash		=		random_string('alnum', 9);
                $link1          =  base_url("assets/web/images/bg-email.png");
                $link2          =  base_url("assets/web/images/bg-footer.png");

                $htmlContent =  '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
  <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>USER PASSWORD RESET LINK</title>
  <style type="text/css" media="screen">

    /* Force Hotmail to display emails at full width */
    .ExternalClass {
      display: block !important;
      width: 100%;
    }

    /* Force Hotmail to display normal line spacing */
    .ExternalClass,
    .ExternalClass p,
    .ExternalClass span,
    .ExternalClass font,
    .ExternalClass td,
    .ExternalClass div {
      line-height: 100%;
    }

    body,
    p,
    h1,
    h2,
    h3,
    h4,
    h5,
    h6 {
      margin: 0;
      padding: 0;
    }

    body,
    p,
    td {
      font-family: Arial, Helvetica, sans-serif;
      font-size: 15px;
      color: #333333;
      line-height: 1.5em;
    }

    h1 {
        text-align: center;
    font-size: 20px;
    font-weight: bold;
    line-height: 24px;
    }

    body,
    p {
      margin-bottom: 0;
      -webkit-text-size-adjust: none;
      -ms-text-size-adjust: none;
    }

    img {
      outline: none;
      text-decoration: none;
      -ms-interpolation-mode: bicubic;
    }

    a img {
      border: none;
    }

    .background {
                background-color: #eeeeee;
}


    table.background {
      margin: 0;
      padding: 0;
      width: 100% !important;
    }

    .block-img {
      display: block;
      line-height: 0;
    }

    a {
      color: white;
      text-decoration: none;
    }

    a,
    a:link {
      color: #2A5DB0;
      text-decoration: underline;
    }

    table td {
      border-collapse: collapse;
    }

    td {
      vertical-align: top;
      text-align: left;
    }

    .wrap {
	    margin-top: 0px;
      width: 600px;
    }

    .wrap-cell {
      padding-top: 30px;
      padding-bottom: 30px;
    }

    .header-cell,
    .body-cell,
    .footer-cell {
      padding-left: 20px;
      padding-right: 20px;
    }

    .header-cell {


      color: #ffffff;
    }

    .body-cell {
      background-color: #ffffff;
      padding-top:16px;
      padding-bottom: 34px;
    }

    .footer-cell {

      text-align: center;
      font-size: 13px;
      padding-top:13px;
      padding-bottom: 30px;
    }

    .card {
      width: 400px;
      margin: 0 auto;
    }

    .data-heading {
      text-align: right;
      padding: 10px;
      background-color: #ffffff;
      font-weight: bold;
    }

    .data-value {
      text-align: left;
      padding: 10px;
      background-color: #ffffff;
    }

    .force-full-width {
      width: 100% !important;
    }

  </style>
  <style type="text/css" media="only screen and (max-width: 600px)">
    @media only screen and (max-width: 600px) {
      body[class*="background"],
      table[class*="background"],
      td[class*="background"] {
        background: #eeeeee !important;
      }

      table[class="card"] {
        width: auto !important;
      }

      td[class="data-heading"],
      td[class="data-value"] {
        display: block !important;
      }

      td[class="data-heading"] {
        text-align: left !important;
        padding: 10px 10px 0;
      }

      table[class="wrap"] {
        width: 100% !important;
      }

      td[class="wrap-cell"] {
        padding-top: 0 !important;
        padding-bottom: 0 !important;
      }
    }


  </style>
</head>

<body leftmargin="0" marginwidth="0" topmargin="0" marginheight="0" offset="0" bgcolor="" class="background">
  <table align="center" border="0" cellpadding="0" cellspacing="0" height="100%" width="100%" class="background">
    <tr>
      <td align="center" valign="top" width="100%" class="background">
        <center>
          <table cellpadding="0" cellspacing="0" width="600" class="wrap">
            <tr>
              <td valign="top" class="wrap-cell" style="padding-top:0px; padding-bottom:0px;">
                <table cellpadding="0" cellspacing="0" class="force-full-width">
				 <tr>
                    <td height="8" bgcolor="#ededed" class="contents" style="width:100%; border-top-left-radius:0px; border-top-right-radius:0px"></td>
                  </tr>
                  <tr>
                   <td height="65" valign="top" class="header-cell" style="padding-top:30px; padding-bottom:30px; background-image:url('.$link1.')">
                   <a href="'.site_url().'" target="_blank">
                   <img src="'.base_url("assets/web/images/20.png").'" width="150"  alt="" style="border-width:0; max-width:100px; display:block" /></a>
                   </td>
                   </tr>
                   <tr>
                   <td height="4" bgcolor="#ffa50070" class="contents" style="width:100%; border-top-left-radius:0px; border-top-right-radius:0px"><!--  border-top-left-radius:10px; --> <!-- border-top-right-radius:10px" --></td>
                                          </tr>

                  <tr>
                    <td valign="top" class="body-cell">

                      <table cellpadding="0" cellspacing="0" width="100%" bgcolor="#ffffff">
                      <tr>
                      <td valign="top" style="padding-bottom:15px; background-color:#ffffff;">
                      <h1>Password reset link</h1>
                      </td>
                      </tr>
                      <tr>
                      <td valign="top" style="padding-bottom:20px; background-color:#ffffff;">
                      <p style="color:#5b5f65; font-size:14px; text-align:justify; font-family: Verdana, Geneva, sans-serif">
                      Your password reset link is as follows. Please click the link
                      below to reset your password.<br>
                      </p>
                      <center>    <a href="'.site_url("teacher/password/reset/").$row->hashtag.$row->id.$salthash.'"
                      style="background-color:#ffa500;color:#ffffff;display:inline-block;font-family:sans-serif;font-size: 16px;line-height:37px;text-align:center;text-decoration:none;width:165px;-webkit-text-size-adjust:none;">Password Reset Link</a>
                      </center>
                      <br>
                      <p style="color:#5b5f65; font-size:14px; text-align:justify;font-family: Verdana, Geneva, sans-serif">

                      Thank you for your patience. Please contact us for any inconvenience caused to you.<br>


                      </p>
                      </td>
                      </tr>
                      <tr>
                      <td>
                      <table cellspacing="0" cellpadding="0" width="100%" bgcolor="#ffffff">
                      <tr>
                      <td style="width:200px;background:#008000;">
                      <div><!--[if mso]>
                      <v:rect xmlns:v="urn:schemas-microsoft-com:vml" xmlns:w="urn:schemas-microsoft-com:office:word" href="#" style="height:40px;v-text-anchor:middle;width:200px;" stroke="f" fillcolor="#008000">
                      <w:anchorlock/>
                      <center>
                      <![endif]-->


                      <!--[if mso]>
                      </center>
                      </v:rect>
                      <![endif]--></div>
                      </td>
                      <td width="360" style="background-color:#ffffff; font-size:0; line-height:0;">&nbsp;</td>
                      </tr>
                      </table>
                      </td>
                      </tr>
                      <tr>
                      <td style="padding-top:20px;background-color:#ffffff;">
                      <p style="color:black;  font-family: Comic Sans MS, Textile, cursive; font-weight: bold;">

                      Regards.<br>
                      The Online Gurukul
                      </p>
                      </td>
                      </tr>
                      </table>
                      </td>
                      </tr>
                      <tr>
                      <td height="4" bgcolor="#ffa50070" class="contents" style="width:100%; border-top-left-radius:0px; border-top-right-radius:0px"></td>
                      </tr>

                      <tr>
                       <td height="65" align="center" class="header-cell" style="padding-top:7px; padding-bottom:7px; background-image:url('.$link1.')">

                      <center><span class="email-cos" style="font-size: 14px; color: #ffa500; font-weight: bolder;">Email :</span>
                      <a class="txs" href="mailto:helpdesk@theonlinegurukul.com" style="color:#000;  font-size:17px;text-decoration:none;" target="_blank">helpdesk@theonlinegurukul.com </a>
                      <br>
                      <span class="email-cos" style="font-size: 14px; color: #ffa500; font-weight: bolder;">Phone :-</span>
                      <a class="txs" href="tel:+91-0124-4272441" style="color:#000;  font-size:17px;text-decoration:none;" target="_blank"> 91-0124-4272441</a>
                      </center>
                      </td>
                      <tr>

                      </tr>



                      </table>
                      </td>
                      </tr>
                      </table>
                      </center>
                      </td>
                      </tr>
                      </table>

                      </body>
                      </html>';

                $this->email->message($htmlContent);

                if ($this->email->send()) {
                    $this->session->set_flashdata('success', " Password resent link mail sent to your account,Click link to reset password");
                    return redirect('teacher/password/forget');
                }
                else{
                    //show_error($this->email->print_debugger());
                    $this->session->set_flashdata('danger', " Error in sending Email, please contact Admin");
                    return redirect('teacher/password/forget');
                }

                //return redirect('Web/teacher_forget_password');
            }
            else{
                $this->session->set_flashdata('danger','This Email is not registered with us as Teacher Profile');
                return redirect('user/info');
            }
        }
        else{
            $this->load->view('web/teacher_forget_password',['category'=>$category]);
        }

        $this->load->view('web/footer');
    }

    public function teacher_pass_reset($hash){
        //echo $hash;die;
        $this->load->library('email');
        $this->load->view('web/header',['title'=>'TEACHER PASSWORD RESET :: TOG',"hits"=>$this->hits]);
        $this->form_validation->set_error_delimiters('<p class="font-bold col-pink">', '</p>');
        $this->form_validation->set_rules('password','password','required|trim|xss_clean|min_length[8]|max_length[15]');
        $this->form_validation->set_rules('confirm_password','confirm_password','required|trim|xss_clean|min_length[8]|max_length[15]|matches[password]');
        $hashnew    =   substr($hash,-9);
        $hashcode   =   substr($hash,0,16);
        $hashidtag  =   strstr($hash,$hashnew,true);
        $hashid     =   substr($hashidtag,16);
        if($this->form_validation->run()){
            $password			=   trim($this->input->post('password'));
            $hash_password 	    = 	$this->bcrypt->hash_password($password);
            $count              =   $this->common_model->count_email_confirm($hashid,$hashcode);
            if($count>0){

                /*echo $hashnew."<br>";
                 echo $hashid."<br>";
                 echo $hashcode."<br>";
                 die;*/
                $getrow = $this->common_model->select_email_confirm($hashid,$hashcode);
                //echo "<pre>";print_r($getrow);die;
                if($getrow->category==1){
                    $this->common_model->email_verified_process_done($hashid,$hashcode);
                    $this->common_model->reset_password_user($hashid,$hashcode,$hash_password);
                    $hashnew    =    random_string('alnum', 16);
                    $this->common_model->update_hash($hashid,$hashnew);
                    $this->session->set_flashdata('success', " Email Password reset Sucessfully,please Login to your Account");
                    return redirect('teacher/signin');

                }
            }else{

                $this->session->set_flashdata('danger', " Link is already expired,please contact Admin for assistance  ");
                return redirect('user/info');
            }
        }else{
            $this->load->view('web/teacher_password_reset');
        }

        $this->load->view('web/footer');
    }

    /////////SOCIAL AUTH ??////////

    public function term_and_conditions(){

        $this->load->view('web/header',['title'=>'TERM|CONDITIONS :: TOG',"hits"=>$this->hits]);
        $this->load->view('web/terms');
        $this->load->view('web/footer');
    }
    public function privacy_policy(){

        $this->load->view('web/header',['title'=>'PRIVACY-POLICY :: TOG',"hits"=>$this->hits]);
        $this->load->view('web/policy');
        $this->load->view('web/footer');
    }

    public function student_fblogin(){
        if($this->session->userdata('ss_id')){
            return redirect('Student');
        }
        $data2['user'] = array();
        // Check if user is logged in
        if ($this->facebook->is_authenticated()){
            // User logged in, get user details
            $user                           = $this->facebook->request('get', '/me?fields=id,email,gender,first_name,last_name,picture');

            if (!isset($user['error'])){
                $user_got                   = $this->common_model->checkIfUserExist_fb($user['id']);
                if(!$user_got){
                    $data2['user']          = $user;
                    $hashtag		        = random_string('alnum', 16);
                    $data['email']          = $user['email'];
                    $data['gender']         = $user['gender'];
                    $data['first_name']     = $user['first_name'];
                    $data['last_name']      = $user['last_name'];
                    $data['fb_id']          = $user['id'];
                    // $data['dob']          = false;
                    $data['profile_image']  = $user['picture']['data']['url'];
                    $data['category']       = 2;
                    $data['hashtag']        = $hashtag;
                    //echo "<pre>";print_r($data);die;

                    $ins = $this->common_model->insert_fb($data);
                    $this->load->library('session');
                    $this->session->set_userdata('ss_id',$data['hashtag'].$ins);
                    //echo $this->session->userdata('ss_id');die;
                    return redirect('Student/class_scheduled_list');
                }else{
                    $this->session->set_userdata('ss_id',$user_got->hashtag.$user_got->id);
                    //echo $this->session->userdata('ss_id');die;
                    return redirect('Student');
                }
            }else{
                $this->session->set_flashdata('danger','error occoured');
                return redirect($this->facebook->login_url());
            }
            // var_dump($user);
            //echo $user['id']."<br><br>";
           /*  echo $user['first_name']."<br><br>";
            echo $user['last_name']."<br><br>";
            echo $user['email']."<br><br>";
            echo $user['gender']."<br><br>";
            echo "<img src='".$user['picture']['data']['url']."'>"."<br><br>";
            // echo "<pre>";print_r($data['user']);
            //$this->facebook->destroy_session();
            echo "<a href='".site_url('Web/fb_logout')."'>Logout</a>"; */


        }else{
            // $this->session->set_flashdata('danger','error occoured');
            return redirect($this->facebook->login_url());
        }
    }
    function student_instalogin() {
        if($this->session->userdata('ss_id')){
            return redirect('Student');
        }
        // Make sure that there is a GET variable of code
        if(isset($_GET['code']) && $_GET['code'] != '') {

            $auth_response = $this->instagram_api->authorize($_GET['code']);
            $user_got   = $this->common_model->checkIfUserExist_insta($auth_response->user->id);
            if(!$user_got){
//             echo $auth_response->access_token."<br><br>";
//             echo $auth_response->user->username."<br><br>";
//             echo $auth_response->user->profile_picture."<br><br>";
//             echo $auth_response->user->id."<br><br>";
//             echo $auth_response->user->full_name."<br><br>";
//             echo "<img src='".$auth_response->user->profile_picture."'>"."<br><br>";
//             echo "<a href='".site_url('Web/insta_logout')."'>Logout</a>";
               $data['insta_id']            =   $auth_response->user->id;
               $data['profile_image']       =   $auth_response->user->profile_picture;
               $data['full_name']           =   $auth_response->user->full_name;
               $hashtag		                =   random_string('alnum', 16);
               $data['category']            =   2;
               $data['hashtag']             =   $hashtag;
                $ins                        =   $this->common_model->insert_insta($data);
                $data1['username']          =   $auth_response->user->username;
                $data1['access_token']      =   $auth_response->user->access_token;
                $data1['master_user_id']    =   $ins;
                if($ins!=""){
                    $this->common_model->insert_insta_info($data1);
                }
            $this->load->library('session');
            $this->session->set_userdata('ss_id',$data['hashtag'].$ins);
            //echo $this->session->userdata('ss_id');die;
            return redirect('Student');
            }else{
                $this->session->set_userdata('ss_id',$user_got->hashtag.$user_got->id);
                //echo $this->session->userdata('ss_id');die;
                return redirect('Student');
            }

        } else {
            // There was no GET variable so redirect back to the homepage
            return redirect($this->instagram_api->instagram_login());
        }
    }
    function student_twitterlogin() {
        if($this->session->userdata('ss_id')){
            return redirect('Student');
        }
        if($this->session->userdata('login') == true){
            redirect('welcome/profile');
        }

        $ok = $this->twconnect->twredirect('welcome/callback');
        //echo $ok; echo "$this->twconnect->twredirect('welcome/callback')";die;
        if (!$ok) {
            echo 'Could not connect to Twitter. Refresh the page or try again later.';
            return redirect('student/signin');
        }
    }
    function student_lnklogin() {

        return   redirect('linkedin_signup/initiate');
    }
    function student_gpluslogin() {

        // Make sure that there is a GET variable of code
        if($this->session->userdata('ss_id')){
            return redirect('Student');
        }
        if (isset($_GET['code'])) {

            $this->googleplus->getAuthenticate();
            //  $this->session->set_userdata('login',true);
            //$this->session->set_userdata('user_profile',$this->googleplus->getUserInfo());
            // redirect('login/saveUser');
            $info = $contents['user_profile'] = $this->googleplus->getUserInfo();
            $user_got   = $this->common_model->checkIfUserExist_google( $info['id']);
            if(!$user_got){
                 $hashtag		         = random_string('alnum', 16);
                 $data['email']          = $info['email'];
                 $data['full_name']      = $info['name'];
                 $data['first_name']     = $info['given_name'];
                 $data['last_name']      = $info['family_name'];
                 $data['google_id']      = $info['id'];
               //  $data['gender']         = isset($info['gender']) ? $info['gender'] : '';
                 $data['gender']         = $info['gender'];
                // $data['dob']          = false;
                 $data['profile_image']  = $info['picture'];
                 $data['category']       = 2;
                 $data['hashtag']        = $hashtag;

                 //$data['gpluslink']      = false;
                 $this->session->set_flashdata('success','User Successfully logout');
              /*  echo $info['id']."<br><br>";
                echo $info['email']."<br><br>";
                echo $info['name']."<br><br>";
                echo $info['given_name']."<br><br>";
                echo $info['family_name']."<br><br>";
                echo $info['gender']."<br><br>";
                echo "<img src='".$info['picture']."'>"."<br><br>";
                echo "<a href='".site_url('Web/gplus_logout')."'>Logout</a>";
                die; */
                $ins = $this->common_model->insert_google($data);
                 //echo $ins;die;

                $this->session->set_userdata('ss_id',$data['hashtag'].$ins);
                //echo $this->session->userdata('ss_id');die;
                return redirect('Student');
            }else{
                $this->session->set_userdata('ss_id',$user_got->hashtag.$user_got->id);
                //echo $this->session->userdata('ss_id');die;
                return redirect('Student');
            }

        } else {
            // There was no GET variable so redirect back to the homepage
            return redirect('student/signin');
        }
    }

    public function fb_logout(){
        $this->facebook->destroy_session();
        //$this->facebook->logout_url();
        return redirect('student/signin');
    }
    public function insta_logout(){
        $this->facebook->destroy_session();
        //$this->facebook->logout_url();
        $this->session->set_flashdata('success','User Successfully logout');
        return redirect('student/signin');
    }
    public function twitter_logout(){
        $this->facebook->destroy_session();
        //$this->facebook->logout_url();
        $this->session->set_flashdata('success','User Successfully logout');
        return redirect('student/signin');
    }
    public function lnk_logout(){
        $this->facebook->destroy_session();
        //$this->facebook->logout_url();
        $this->session->set_flashdata('success','User Successfully logout');
        return redirect('student/signin');
    }
    public function gplus_logout(){
        $this->facebook->destroy_session();
        //$this->facebook->logout_url();
        $this->session->set_flashdata('success','User Successfully logout');
        return redirect('student/signin');
    }
    public function page_not_found_404(){
        $this->load->view('web/error_404');
    }

    public function check_curl_request(){

      $curl = curl_init();
      // Set some options - we are passing in a useragent too here
      curl_setopt_array($curl, array(
            CURLOPT_RETURNTRANSFER => 1,
            CURLOPT_URL => 'http://classapi.wiziqxt.com/apimanager.ashx?method=create,',
            CURLOPT_USERAGENT => 'Codular Sample cURL Request',
            CURLOPT_POST => 1,
            CURLOPT_POSTFIELDS => array(
                item1 => 'value',
                item2 => 'value2'
            )
        ));
        // Send the request & save response to $resp
        if(!curl_exec($curl)){
          echo 'Error: "' . curl_error($curl) . '" - Code: ' . curl_errno($curl);
        }else{
          $resp = curl_exec($curl);
          var_dump($resp);
          die;
        }
        // Close request to clear up some resources
        curl_close($curl);
    }
    function check_curl2(){

         $url            =   "http://classapi.wiziqxt.com/apimanager.ashx?method=create,&api-key=$this->rs_api_key&domain-name=$domain_name&tlds=".$ext;
        //echo $url;die;
         $ch             =   curl_init();
         $timeout        =   60;
         curl_setopt($ch, CURLOPT_URL, $url);
         curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
         curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
         curl_setopt($ch, CURLOPT_HEADER, false);
         curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, $timeout);

         if(!curl_exec($ch)){
          die('Error: "' . curl_error($curl) . '" - Code: ' . curl_errno($curl));
         }
         else{
          $resp = curl_exec($ch);
          var_dump($resp);
          die;
         }
         curl_close($ch);
     }
     public function timezone(){
      // $this->load->view("Web/timezone");
	    $html='
      <script>
        function getTimeZoneData() {
          var today = new Date();
            var jan = new Date(today.getFullYear(), 0, 1);
            var jul = new Date(today.getFullYear(), 6, 1);
            var dst = today.getTimezoneOffset() < Math.max(jan.getTimezoneOffset(), jul.getTimezoneOffset());
            return {
              offset: -today.getTimezoneOffset() / 60,
              dst: +dst
            };
          }
      </script>';
  $html.=" <script src='".base_url('assets/jquery2_0_2.min.js')."'></script>";
	echo $html;
	?>

		 <script>
         $(document).ready(function(){
           $.ajax({
             url: "<?=site_url('Timezone/timezone_detect');?>",
             data: getTimeZoneData(),
             method: "POST",
             dataType: "JSON"
           }).done(function(data) {
             $("#timezone").html(data);
           });
         });
       </script>
	 <?php

       echo '<body>
             <h1>Your timezone is:</h1>
             <h2 id="timezone">...</h2>
           </body>';

     }






}
?>
